/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.vector.abstracts.floatn;

import de.linusdev.lutils.math.elements.FloatElement;
import de.linusdev.lutils.math.vector.Vector;
import org.jetbrains.annotations.NotNull;

public interface FloatN
extends Vector,
FloatElement {
    public float get(int var1);

    public void put(int var1, float var2);

    @NotNull
    default public View getAsView() {
        throw new UnsupportedOperationException("This vector is not a view on another vector.");
    }

    @NotNull
    default public FloatN fillFromArray(float @NotNull [] data) {
        for (int x = 0; x < this.getMemberCount(); ++x) {
            this.put(x, data[x]);
        }
        return this;
    }

    public static abstract class View
    extends Vector.View<FloatN>
    implements FloatN {
        protected View(@NotNull FloatN original, int @NotNull [] mapping) {
            super(original, mapping);
        }

        @Override
        public float get(int index) {
            return ((FloatN)this.original).get(this.mapping[index]);
        }

        @Override
        public void put(int index, float value) {
            ((FloatN)this.original).put(this.mapping[index], value);
        }

        @Override
        public boolean hasFactor() {
            return false;
        }

        public float @NotNull [] getFactor() {
            throw new UnsupportedOperationException("This view has no factor");
        }

        @Override
        @NotNull
        public View getAsView() {
            return this;
        }

        public String toString() {
            return Vector.toString(this, "float", FloatN::get);
        }
    }

    public static abstract class FactorView
    extends View
    implements FloatN {
        protected final float @NotNull [] factor;

        static float @NotNull [] recalculateFactorToOriginal(@NotNull View view, int @NotNull [] mapping, float @NotNull [] factor) {
            float[] viewFactor = view.getFactor();
            float[] newFactor = new float[factor.length];
            for (int i = 0; i < mapping.length; ++i) {
                newFactor[i] = viewFactor[mapping[i]] * factor[i];
            }
            return newFactor;
        }

        protected FactorView(@NotNull FloatN original, int @NotNull [] mapping, float @NotNull [] factor) {
            super(original, mapping);
            this.factor = original.isView() && original.getAsView().hasFactor() ? FactorView.recalculateFactorToOriginal(original.getAsView(), mapping, factor) : factor;
        }

        @Override
        public float get(int index) {
            return ((FloatN)this.original).get(this.mapping[index]) * this.factor[index];
        }

        @Override
        public void put(int index, float value) {
            ((FloatN)this.original).put(this.mapping[index], value / this.factor[index]);
        }

        @Override
        public boolean hasFactor() {
            return true;
        }

        @Override
        public float @NotNull [] getFactor() {
            return this.factor;
        }
    }
}

