/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.abi;

import de.linusdev.lutils.nat.MemorySizeable;
import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.abi.Types;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.info.UnionInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ABI {
    public static boolean equals(@NotNull ABI that, @Nullable ABI other) {
        return other != null && that.identifier().equals(other.identifier());
    }

    @NotNull
    public String identifier();

    @NotNull
    public StructureInfo calculateStructureLayout(boolean var1, MemorySizeable ... var2);

    @NotNull
    public UnionInfo calculateUnionLayout(boolean var1, MemorySizeable ... var2);

    @NotNull
    public ArrayInfo calculateArrayLayout(boolean var1, @NotNull MemorySizeable var2, int var3, int var4);

    @NotNull
    default public ArrayInfo calculateVectorLayout(@NotNull NativeType componentType, int length) {
        return this.calculateArrayLayout(false, componentType.getMemorySizeable(this.types()), length, -1);
    }

    @NotNull
    default public ArrayInfo calculateMatrixLayout(@NotNull NativeType componentType, int width, int height) {
        return this.calculateArrayLayout(false, componentType.getMemorySizeable(this.types()), width * height, -1);
    }

    @NotNull
    public Types types();
}

