/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.abi;

import de.linusdev.lutils.nat.MemorySizeable;
import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.Types;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.info.UnionInfo;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DefaultABIs implements ABI,
Types
{
    DEFAULT{

        @Override
        @NotNull
        public ABI getAbi() {
            return _DEFAULT;
        }

        @Override
        @NotNull
        public MemorySizeable integer() {
            return _DEFAULT.types().integer();
        }

        @Override
        @NotNull
        public MemorySizeable int8() {
            return _DEFAULT.types().int8();
        }

        @Override
        @NotNull
        public MemorySizeable int16() {
            return _DEFAULT.types().int16();
        }

        @Override
        @NotNull
        public MemorySizeable int32() {
            return _DEFAULT.types().int32();
        }

        @Override
        @NotNull
        public MemorySizeable int64() {
            return _DEFAULT.types().int64();
        }

        @Override
        @NotNull
        public MemorySizeable float32() {
            return _DEFAULT.types().float32();
        }

        @Override
        @NotNull
        public MemorySizeable float64() {
            return _DEFAULT.types().float64();
        }

        @Override
        @NotNull
        public MemorySizeable pointer() {
            return _DEFAULT.types().pointer();
        }

        @Override
        @NotNull
        public StructureInfo calculateStructureLayout(boolean compress, MemorySizeable ... children) {
            return _DEFAULT.calculateStructureLayout(compress, children);
        }

        @Override
        @NotNull
        public UnionInfo calculateUnionLayout(boolean compress, MemorySizeable ... children) {
            return _DEFAULT.calculateUnionLayout(compress, children);
        }

        @Override
        @NotNull
        public ArrayInfo calculateArrayLayout(boolean compress, @NotNull MemorySizeable children, int length, int stride) {
            return _DEFAULT.calculateArrayLayout(compress, children, length, stride);
        }

        @Override
        @NotNull
        public ArrayInfo calculateVectorLayout(@NotNull NativeType componentType, int length) {
            return _DEFAULT.calculateVectorLayout(componentType, length);
        }

        @Override
        @NotNull
        public Types types() {
            return _DEFAULT.types();
        }
    }
    ,
    MSVC_X64{
        @NotNull
        private final MemorySizeable POINTER64 = MemorySizeable.of(8);

        @Override
        @NotNull
        public ABI getAbi() {
            return this;
        }

        @Override
        @NotNull
        public MemorySizeable integer() {
            return this.int32();
        }

        @Override
        @NotNull
        public MemorySizeable pointer() {
            return this.POINTER64;
        }

        @Override
        @NotNull
        public StructureInfo calculateStructureLayout(boolean compress, MemorySizeable ... children) {
            int alignment = 1;
            int[] sizes = new int[children.length * 2 + 1];
            int padding = 0;
            int position = 0;
            int i = 0;
            while (i < children.length) {
                MemorySizeable child = children[i];
                if (position % child.getAlignment() != 0 && !compress) {
                    int offset = child.getAlignment() - position % child.getAlignment();
                    position += offset;
                    padding += offset;
                    continue;
                }
                sizes[i * 2] = padding;
                sizes[i * 2 + 1] = child.getRequiredSize();
                position += child.getRequiredSize();
                padding = 0;
                alignment = Math.max(alignment, child.getAlignment());
                ++i;
            }
            if (compress) {
                alignment = 1;
            }
            if (position % alignment != 0) {
                sizes[sizes.length - 1] = alignment - position % alignment;
                position += sizes[sizes.length - 1];
            } else {
                sizes[sizes.length - 1] = 0;
            }
            return new StructureInfo(alignment, compress, position, sizes);
        }

        @Override
        @NotNull
        public UnionInfo calculateUnionLayout(boolean compress, MemorySizeable ... children) {
            int alignment = 1;
            int[] positions = new int[children.length];
            int size = 0;
            int postPadding = 0;
            for (int i = 0; i < children.length; ++i) {
                MemorySizeable child = children[i];
                positions[i] = 0;
                alignment = Math.max(alignment, child.getAlignment());
                size = Math.max(size, child.getRequiredSize());
            }
            if (compress) {
                alignment = 1;
            }
            if (size % alignment != 0) {
                postPadding = alignment - size % alignment;
            }
            return new UnionInfo(alignment, compress, 0, size, postPadding, positions);
        }

        @Override
        @NotNull
        public ArrayInfo calculateArrayLayout(boolean compress, @NotNull MemorySizeable children, int length, int stride) {
            int alignment = children.getAlignment();
            if (stride == -1) {
                stride = children.getRequiredSize();
                if (!compress && stride < alignment) {
                    stride = alignment;
                }
                if (!compress && stride % alignment != 0) {
                    stride += alignment - stride % alignment;
                }
            }
            int finalStride = stride;
            return new ArrayInfo(alignment, compress, stride * length, new int[]{0, stride * length, 0}, length, stride, index -> index * finalStride);
        }

        @Override
        @NotNull
        public Types types() {
            return this;
        }
    }
    ,
    CVG4J_OPEN_CL{
        @NotNull
        private final MemorySizeable POINTER64 = MemorySizeable.of(8);

        @Override
        @NotNull
        public ABI getAbi() {
            return this;
        }

        @Override
        @NotNull
        public MemorySizeable integer() {
            return this.int32();
        }

        @Override
        @NotNull
        public MemorySizeable pointer() {
            return this.POINTER64;
        }

        private int getBiggestStructAlignment(int min, int max, MemorySizeable ... vars) {
            int biggest = min;
            for (MemorySizeable structure : vars) {
                biggest = Math.max(biggest, structure.getAlignment());
            }
            return Math.min(max, biggest);
        }

        @Override
        @NotNull
        public StructureInfo calculateStructureLayout(boolean compress, MemorySizeable ... children) {
            int alignment = this.getBiggestStructAlignment(4, 16, children);
            int[] sizes = new int[children.length * 2 + 1];
            int padding = 0;
            int position = 0;
            int i = 0;
            while (i < children.length) {
                MemorySizeable structure = children[i];
                if (position % alignment == 0 || alignment - position % alignment >= structure.getRequiredSize()) {
                    int itemSize = structure.getRequiredSize();
                    int itemAlignment = structure.getAlignment();
                    if (!compress && position % itemAlignment != 0) {
                        int offset = itemAlignment - position % itemAlignment;
                        position += offset;
                        padding += offset;
                        continue;
                    }
                    sizes[i * 2] = padding;
                    sizes[i * 2 + 1] = itemSize;
                    position += itemSize;
                    padding = 0;
                    ++i;
                    continue;
                }
                int offset = alignment - position % alignment;
                position += offset;
                padding += offset;
            }
            if (position % alignment != 0) {
                sizes[sizes.length - 1] = alignment - position % alignment;
                position += sizes[sizes.length - 1];
            } else {
                sizes[sizes.length - 1] = 0;
            }
            return new StructureInfo(alignment, compress, position, sizes);
        }

        @Override
        @NotNull
        public UnionInfo calculateUnionLayout(boolean compress, MemorySizeable ... children) {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        @NotNull
        public ArrayInfo calculateArrayLayout(boolean compress, @NotNull MemorySizeable children, int length, int stride) {
            return MSVC_X64.calculateArrayLayout(compress, children, length, stride);
        }

        @Override
        @NotNull
        public ArrayInfo calculateVectorLayout(@NotNull NativeType componentType, int length) {
            int componentSize = componentType.getMemorySizeable(this).getRequiredSize();
            int originalSize = componentSize * length;
            int size = originalSize;
            if (Integer.bitCount(size) != 1) {
                size = Integer.highestOneBit(size) << 1;
            }
            return new ArrayInfo(size, false, size, new int[]{0, originalSize, size - originalSize}, length, componentSize, index -> index * componentSize);
        }

        @Override
        @NotNull
        public Types types() {
            return this;
        }
    };

    @NotNull
    private static ABI _DEFAULT;

    public static void setDefaultAbi(@NotNull ABI _default) {
        _DEFAULT = _default;
    }

    @Override
    @NotNull
    public String identifier() {
        return this.name();
    }

    static {
        _DEFAULT = MSVC_X64;
    }
}

