/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeFloat32Array
extends NativePrimitiveTypeArray<Float> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.FLOAT32);

    public static NativeFloat32Array newUnallocated() {
        return new NativeFloat32Array(null, false);
    }

    public static NativeFloat32Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeFloat32Array(structValue, true);
    }

    public static NativeFloat32Array newAllocated(@NotNull StructValue structValue) {
        NativeFloat32Array ret = NativeFloat32Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeFloat32Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Float get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return Float.valueOf(this.getFloat(index));
    }

    public float getFloat(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.getFloat(this.positions.position(index));
    }

    @Override
    public void set(int index, Float item) {
        this.setFloat(index, item.floatValue());
    }

    public void setFloat(int index, float item) {
        this.byteBuf.putFloat(this.positions.position(index), item);
    }
}

