/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeFloat64Array
extends NativePrimitiveTypeArray<Double> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.FLOAT64);

    public static NativeFloat64Array newUnallocated() {
        return new NativeFloat64Array(null, false);
    }

    public static NativeFloat64Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeFloat64Array(structValue, true);
    }

    public static NativeFloat64Array newAllocated(@NotNull StructValue structValue) {
        NativeFloat64Array ret = NativeFloat64Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeFloat64Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Double get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.getFloat64(index);
    }

    public double getFloat64(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.getDouble(this.positions.position(index));
    }

    @Override
    public void set(int index, Double item) {
        this.setFloat64(index, item);
    }

    public void setFloat64(int index, double item) {
        this.byteBuf.putDouble(this.positions.position(index), item);
    }
}

