/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.integer;

import de.linusdev.lutils.nat.MemorySizeable;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureLayoutSettings;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLayoutOption=RequirementType.OPTIONAL)
@StructureLayoutSettings
public class NativeInteger
extends Structure {
    @NotNull
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @NotNull OverwriteChildABI overwriteChildAbi) {
            MemorySizeable memorySizeable = abi.types().integer();
            return new StructureInfo(memorySizeable.getAlignment(), false, 0, memorySizeable.getRequiredSize(), 0);
        }
    };

    public static NativeInteger newUnallocated() {
        return new NativeInteger(false, null);
    }

    public static NativeInteger newAllocatable(@Nullable StructValue structValue) {
        return new NativeInteger(true, structValue);
    }

    public static NativeInteger newAllocated(@Nullable StructValue structValue) {
        NativeInteger ret = NativeInteger.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeInteger(boolean generateInfo, @Nullable StructValue structValue) {
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, GENERATOR));
        }
    }

    public void set(long value) {
        int size = this.getRequiredSize();
        if (size == 2) {
            if ((long)((short)value) != value) {
                throw new ArithmeticException("short overflow");
            }
            this.byteBuf.putShort(0, (short)value);
        } else if (size == 4) {
            this.byteBuf.putInt(0, Math.toIntExact(value));
        } else if (size == 8) {
            this.byteBuf.putLong(0, value);
        } else {
            throw new Error("Unexpected Integer Size");
        }
    }

    public long get() {
        int size = this.getRequiredSize();
        if (size == 2) {
            return this.byteBuf.getShort(0);
        }
        if (size == 4) {
            return this.byteBuf.getInt(0);
        }
        if (size == 8) {
            return this.byteBuf.getLong(0);
        }
        throw new Error("Unexpected Integer Size");
    }
}

