/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.memory.stack.impl;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.memory.stack.PopPoint;
import de.linusdev.lutils.nat.memory.stack.SafePoint;
import de.linusdev.lutils.nat.memory.stack.Stack;
import de.linusdev.lutils.nat.memory.stack.impl.StackPointerQueue;
import de.linusdev.lutils.nat.size.Size;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLengthOption=RequirementType.OPTIONAL)
public class DirectMemoryStack64
extends Structure
implements Stack {
    public static final int DEFAULT_MEMORY_SIZE = 0x100000;
    public static final int ALIGNMENT = 8;
    private final long address;
    @NotNull
    protected final StackPointerQueue stackPointers;
    public static final StaticGenerator GENERATOR = new StaticGenerator(){

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @NotNull OverwriteChildABI overwriteChildAbi) {
            int size = structValue != null && structValue.length().length > 0 ? structValue.length()[0] : 0x100000;
            return new StructureInfo(8, false, size, new int[]{0, size, 0});
        }
    };

    public DirectMemoryStack64(@NotNull Size size) {
        this(size.getAsInt());
    }

    public DirectMemoryStack64() {
        this(0x100000);
    }

    public DirectMemoryStack64(int size) {
        this.setInfo(new StructureInfo(8, false, 0, size, 0));
        this.allocate();
        this.address = this.getPointer();
        this.stackPointers = new StackPointerQueue(this.address);
    }

    @Override
    public <T extends Structure> T push(@NotNull T structure) {
        long stackPointer = this.stackPointers.getStackPointer();
        StructureInfo info = structure.getOrGenerateInfo();
        int size = info.getRequiredSize();
        int alignment = info.getAlignment();
        int alignmentFix = stackPointer % (long)alignment == 0L ? 0 : (int)((long)alignment - stackPointer % (long)alignment);
        ByteBuffer subBuf = this.byteBuf.slice((int)(stackPointer - this.address + (long)alignmentFix), size);
        BufferUtils.fill(subBuf, (byte)0);
        structure.claimBuffer(subBuf);
        this.stackPointers.push(size + alignmentFix);
        return structure;
    }

    @Override
    @NotNull
    public ByteBuffer pushByteBuffer(int size, int alignment) {
        long stackPointer = this.stackPointers.getStackPointer();
        int alignmentFix = stackPointer % (long)alignment == 0L ? 0 : (int)((long)alignment - stackPointer % (long)alignment);
        ByteBuffer newBuf = this.byteBuf.slice((int)(stackPointer - this.address + (long)alignmentFix), size).order(ByteOrder.nativeOrder());
        this.stackPointers.push(size + alignmentFix);
        return newBuf;
    }

    @Override
    public void pop() {
        this.stackPointers.pop();
    }

    @Override
    @NotNull
    public SafePoint safePoint() {
        return this.stackPointers.safePoint(this);
    }

    @Override
    @NotNull
    public PopPoint popPoint() {
        return this.stackPointers.popPoint(this);
    }

    @Override
    public long memorySize() {
        return this.byteBuf.capacity();
    }

    @Override
    public long usedByteCount() {
        return this.stackPointers.getStackPointer() - this.address;
    }

    @Override
    public int currentStructCount() {
        return this.stackPointers.size();
    }

    @Override
    public int getAlignment() {
        return 8;
    }

    public long getAddress() {
        return this.address;
    }

    public String toString() {
        return this.info();
    }
}

