/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.memory.stack.impl;

import de.linusdev.lutils.nat.memory.stack.SafePointError;
import de.linusdev.lutils.nat.memory.stack.Stack;
import de.linusdev.lutils.nat.memory.stack.impl.SPQPopPoint;
import de.linusdev.lutils.nat.memory.stack.impl.SPQSafePoint;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class StackPointerQueue {
    public final int DEFAULT_CAP = 100;
    public final int DEFAULT_GROW_SIZE = 100;
    public final int DEFAULT_SAFE_POINT_CAP = 100;
    public final int DEFAULT_SAFE_POINT_CAP_GROW_SIZE = 100;
    protected long stackPointer;
    protected long[] pointers = new long[100];
    protected int index = 0;
    protected SPQSafePoint[] safePoints = new SPQSafePoint[100];
    protected int safePointsIndex = 0;

    public StackPointerQueue(long address) {
        this.stackPointer = address;
    }

    public long getStackPointer() {
        return this.stackPointer;
    }

    public void push(long size) {
        this.growPointersIfRequired();
        this.pointers[this.index++] = this.stackPointer;
        this.stackPointer += size;
    }

    public void pop() {
        assert (this.popChecks());
        this.stackPointer = this.pointers[--this.index];
    }

    @NotNull
    public SPQSafePoint safePoint(@NotNull Stack stack) {
        this.growSafePointsIfRequired();
        this.safePoints[this.safePointsIndex] = new SPQSafePoint(this.index, this, stack);
        return this.safePoints[this.safePointsIndex++];
    }

    @NotNull
    public SPQPopPoint popPoint(@NotNull Stack stack) {
        this.growSafePointsIfRequired();
        SPQPopPoint point = new SPQPopPoint(this.index, this, stack);
        this.safePoints[this.safePointsIndex] = point;
        return point;
    }

    protected void checkSafePoint(@NotNull SPQSafePoint safePoint) {
        if (this.index == safePoint.index) {
            --this.safePointsIndex;
            return;
        }
        if (this.index > safePoint.index) {
            throw new SafePointError("SafePoint has not been reached. " + (this.index - safePoint.index) + " too many items are still remaining on the stack and must be popped.");
        }
        throw new SafePointError("SafePoint has not been reached. " + (safePoint.index - this.index) + " too many items have been popped from the stack!");
    }

    protected void popToPopPoint(@NotNull SPQPopPoint popPoint) {
        if (this.index == popPoint.index) {
            --this.safePointsIndex;
            return;
        }
        if (this.index < popPoint.index) {
            throw new SafePointError("SafePoint has not been reached. " + (popPoint.index - this.index) + " too many items have been popped from the stack!");
        }
        this.stackPointer = this.pointers[popPoint.index];
        this.index = popPoint.index;
    }

    public int size() {
        return this.index;
    }

    protected void growPointersIfRequired() {
        if (this.index >= this.pointers.length) {
            this.growPointers(this.pointers.length + 100);
        }
    }

    protected void growPointers(int newCap) {
        this.pointers = Arrays.copyOf(this.pointers, newCap);
    }

    protected void growSafePointsIfRequired() {
        if (this.safePointsIndex >= this.safePoints.length) {
            this.growSafePointers(this.safePoints.length + 100);
        }
    }

    protected void growSafePointers(int newCap) {
        this.safePoints = Arrays.copyOf(this.safePoints, newCap);
    }

    protected boolean popChecks() {
        if (this.index <= 0) {
            throw new IllegalStateException("Cannot pop as no items are in this stack pointer queue");
        }
        if (this.safePointsIndex > 0 && this.index == this.safePoints[this.safePointsIndex - 1].index) {
            throw new SafePointError("Popping this item would reduce the stack pointer past the last safe point. checkSafePoint() must be called first.");
        }
        return true;
    }
}

