/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.size;

import de.linusdev.lutils.nat.size.ByteUnits;
import org.jetbrains.annotations.NotNull;

public class Size {
    private final long size;

    public Size(long size, @NotNull ByteUnits unit) {
        this.size = unit.getValue() * size;
    }

    public Size(long size) {
        this.size = size;
    }

    public long get() {
        return this.size;
    }

    public int getAsInt() {
        assert (this.size < Integer.MAX_VALUE);
        return (int)this.size;
    }

    public String toString() {
        if (ByteUnits.KiB.getValue() > this.size) {
            return this.size + " bytes";
        }
        if (ByteUnits.MiB.getValue() > this.size) {
            return "" + this.size / ByteUnits.KiB.getValue() + ByteUnits.KiB + " bytes";
        }
        if (ByteUnits.GiB.getValue() > this.size) {
            return "" + this.size / ByteUnits.MiB.getValue() + ByteUnits.MiB + " bytes";
        }
        if (ByteUnits.TiB.getValue() > this.size) {
            return "" + this.size / ByteUnits.GiB.getValue() + ByteUnits.GiB + " bytes";
        }
        if (ByteUnits.PiB.getValue() > this.size) {
            return "" + this.size / ByteUnits.TiB.getValue() + ByteUnits.TiB + " bytes";
        }
        return "" + this.size / ByteUnits.PiB.getValue() + ByteUnits.PiB + " bytes";
    }
}

