/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.abstracts;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.info.ComplexUnionInfo;
import de.linusdev.lutils.nat.struct.info.StructVarInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.mod.ModTrackingStructure;
import de.linusdev.lutils.nat.struct.utils.ClassAndAbi;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLayoutOption=RequirementType.OPTIONAL)
public abstract class ComplexUnion
extends ModTrackingStructure {
    @NotNull
    public static final StaticGenerator GENERATOR = new ComplexUnionGenerator();
    protected Structure[] items;

    protected ComplexUnion(boolean trackModifications) {
        super(trackModifications);
    }

    protected void init(@Nullable StructValue structValue, boolean generateInfo, Structure ... items) {
        if (items.length != 0) {
            this.items = items;
        }
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, GENERATOR));
        }
    }

    @Override
    protected void useBuffer(@NotNull Structure mostParentStructure, int offset, @NotNull StructureInfo info) {
        super.useBuffer(mostParentStructure, offset, info);
        if (this.items == null) {
            return;
        }
        ComplexUnionInfo cInfo = this.getInfo();
        StructVarInfo[] childrenInfos = cInfo.getChildrenInfo();
        int[] positions = cInfo.getPositions();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].useBuffer(mostParentStructure, offset + positions[i], childrenInfos[i].getInfo());
        }
    }

    @Override
    @NotNull
    public ComplexUnionInfo getInfo() {
        return (ComplexUnionInfo)super.getInfo();
    }

    @Override
    protected void onSetInfo(@NotNull StructureInfo info) {
        super.onSetInfo(info);
        if (this.items == null) {
            this.items = this.getInfo().getChildren(this);
        }
    }

    @Override
    @Nullable
    protected StructureInfo generateInfo() {
        return SSMUtils.getInfo(this.getClass(), null, null, null, null, null, GENERATOR);
    }

    private static class ComplexUnionGenerator
    implements StaticGenerator {
        @NotNull
        private final Map<ClassAndAbi, ComplexUnionInfo> INFO_MAP = new HashMap<ClassAndAbi, ComplexUnionInfo>();
        @NotNull
        private final Object INFO_MAP_LOCK = new Object();

        private ComplexUnionGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
            Object object = this.INFO_MAP_LOCK;
            synchronized (object) {
                ClassAndAbi key = new ClassAndAbi(selfClazz, abi);
                ComplexUnionInfo info = this.INFO_MAP.get(key);
                if (info == null) {
                    info = ComplexUnionInfo.generateFromStructVars(selfClazz, abi, overwriteChildAbi);
                    this.INFO_MAP.put(key, info);
                }
                return info;
            }
        }
    }
}

