/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.abstracts;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.info.StructVarInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface StructVarUtils {
    public static <T> T getStructVars(@NotNull Class<?> clazz, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi, @NotNull StructVarResultCollector<T> collector) {
        Field[] fields = clazz.getFields();
        StructVarInfo[] varInfos = new StructVarInfo[fields.length];
        int index = 0;
        int size = 0;
        for (Field field : fields) {
            StructVarInfo info = StructVarInfo.ofField(field, abi, overwriteChildAbi);
            if (info == null) continue;
            if (info.getStructValue().value() == -1) {
                varInfos[index++] = info;
            } else {
                varInfos[info.getStructValue().value()] = info;
            }
            ++size;
        }
        StructureInfo[] infos = new StructureInfo[size];
        for (int i = 0; i < size; ++i) {
            infos[i] = varInfos[i].getInfo();
        }
        return collector.collect(Arrays.copyOf(varInfos, size), infos);
    }

    @FunctionalInterface
    public static interface StructVarResultCollector<T> {
        public T collect(@NotNull @NotNull StructVarInfo @NotNull [] var1, @NotNull @NotNull StructureInfo @NotNull [] var2);
    }
}

