/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.info;

import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.ElementsStructValue;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.exception.IllegalStructVarException;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructVarInfo {
    @NotNull
    protected final StructValue structValue;
    @NotNull
    protected final Class<? extends Structure> clazz;
    @NotNull
    protected final String varName;
    @NotNull
    protected final StructureInfo info;
    @NotNull
    protected final Field field;

    @Nullable
    public static StructVarInfo ofField(@NotNull Field field, @Nullable ABI parentAbi, @Nullable OverwriteChildABI overwriteChildAbi) {
        @NotNull Class<?> fieldClass = field.getType();
        StructValue sv = field.getAnnotation(StructValue.class);
        ElementsStructValue esv = field.getAnnotation(ElementsStructValue.class);
        if (sv == null) {
            return null;
        }
        StructureInfo info = SSMUtils.getInfo(fieldClass, sv, esv, parentAbi, overwriteChildAbi, field, null);
        return new StructVarInfo(sv, fieldClass, field.getName(), info, field);
    }

    public StructVarInfo(@NotNull StructValue structValue, @NotNull Class<? extends Structure> clazz, @NotNull String varName, @NotNull StructureInfo info, @NotNull Field field) {
        this.structValue = structValue;
        this.clazz = clazz;
        this.varName = varName;
        this.info = info;
        this.field = field;
    }

    @NotNull
    public StructValue getStructValue() {
        return this.structValue;
    }

    @NotNull
    public Class<? extends Structure> getClazz() {
        return this.clazz;
    }

    @NotNull
    public String getVarName() {
        return this.varName;
    }

    @NotNull
    public StructureInfo getInfo() {
        return this.info;
    }

    public Structure get(@NotNull Structure instance) {
        try {
            return (Structure)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw (IllegalStructVarException)new IllegalStructVarException(this.field, "Cannot access field.").initCause(e);
        }
    }
}

