/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.struct.utils;

import de.linusdev.lutils.nat.struct.utils.Utils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BufferUtils {
    private static final long BUFFER_VARIABLE_ADDRESS_OFFSET;
    @Nullable
    private static ByteBufferFromPointerMethod byteBufferFromPointerMethod;

    @NotNull
    public static ByteBuffer createAligned(int capacity, long alignment) {
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)((long)capacity + alignment - 1L));
        long address = BufferUtils.getHeapAddress(buffer);
        if (address % alignment == 0L) {
            buffer.position(0);
            buffer.limit(capacity);
            return buffer.slice().order(ByteOrder.nativeOrder());
        }
        buffer.position((int)(alignment - address % alignment));
        buffer.limit(buffer.position() + capacity);
        return buffer.slice().order(ByteOrder.nativeOrder());
    }

    @NotNull
    public static ByteBuffer create64BitAligned(int capacity) {
        return BufferUtils.createAligned(capacity, 8L);
    }

    public static long getHeapAddress(@NotNull ByteBuffer buffer) {
        return Utils.UNSAFE.getLong(buffer, BUFFER_VARIABLE_ADDRESS_OFFSET);
    }

    @NotNull
    public static String readString(@NotNull ByteBuffer str, boolean endsWithZero) {
        if (endsWithZero) {
            str.limit(str.limit() - 1);
            str = str.slice();
        }
        return StandardCharsets.UTF_8.decode(str).toString();
    }

    @NotNull
    public static String readNullTerminatedUtf8String(long pointer) {
        ByteBuffer strBuffer = BufferUtils.getByteBufferFromPointer(pointer, 0);
        return StandardCharsets.UTF_8.decode(strBuffer).clear().toString();
    }

    @Deprecated
    @NotNull
    public static ByteBuffer slice(@NotNull ByteBuffer buffer, int start, int length) {
        int op = buffer.position();
        int ol = buffer.limit();
        buffer.position(start);
        buffer.limit(start + length);
        ByteBuffer slice = buffer.slice();
        buffer.position(op);
        buffer.limit(ol);
        return slice;
    }

    public static void setByteBufferFromPointerMethod(@NotNull ByteBufferFromPointerMethod method) {
        byteBufferFromPointerMethod = method;
    }

    @NotNull
    public static ByteBuffer getByteBufferFromPointer(long pointer, int capacity) {
        if (byteBufferFromPointerMethod == null) {
            throw new IllegalStateException("BufferUtils.byteBufferFromPointerMethod must be set, before calling this method. Please call BufferUtils.setByteBufferFromPointerMethod() with an appropriate method.");
        }
        return byteBufferFromPointerMethod.getByteBufferFromPointer(pointer, capacity);
    }

    public static void fill(@NotNull ByteBuffer byteBuffer, byte value) {
        assert (byteBuffer.isDirect());
        Utils.UNSAFE.setMemory(BufferUtils.getHeapAddress(byteBuffer), byteBuffer.capacity(), value);
    }

    static {
        try {
            BUFFER_VARIABLE_ADDRESS_OFFSET = Utils.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        byteBufferFromPointerMethod = null;
    }

    @FunctionalInterface
    public static interface ByteBufferFromPointerMethod {
        @NotNull
        public ByteBuffer getByteBufferFromPointer(long var1, int var3);
    }
}

