/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.header.value;

import de.linusdev.lutils.net.http.header.Header;
import de.linusdev.lutils.net.http.header.value.BasicHeaderValueImpl;
import de.linusdev.lutils.net.http.header.value.HeaderValue;
import de.linusdev.lutils.net.http.header.value.HeaderValueParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicHeaderValue
extends HeaderValue {
    public static final HeaderValueParser<BasicHeaderValue> PARSER = new HeaderValueParser<BasicHeaderValue>(){

        @Override
        @NotNull
        public BasicHeaderValue parse(@NotNull Header header) {
            String value = header.getValue();
            String[] split = value.split(";");
            String[] values = split[0].split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].strip();
            }
            HashMap<String, String> parameters = new HashMap<String, String>(2);
            for (int i = 1; i < split.length; ++i) {
                String[] parameter = split[i].split("=");
                parameters.put(parameter[0].strip(), parameter[1].strip());
            }
            return new BasicHeaderValueImpl(new ArrayList<String>(List.of(values)), parameters);
        }

        @Override
        @NotNull
        public String parse(@NotNull BasicHeaderValue value) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String string : value.getValues()) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append(string);
            }
            if (value.getParameters().isEmpty()) {
                return sb.toString();
            }
            for (Map.Entry entry : value.getParameters().entrySet()) {
                sb.append("; ").append((String)entry.getKey()).append("=").append((String)entry.getValue());
            }
            return sb.toString();
        }
    };

    @NotNull
    public @NotNull List<@NotNull String> getValues();

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull String> getParameters();

    @Nullable
    default public String get(@NotNull String name) {
        return this.getParameters().get(name);
    }

    @NotNull
    default public BasicHeaderValue set(@NotNull String name, @Nullable String value) {
        if (value == null) {
            this.getParameters().remove(name);
        } else {
            this.getParameters().put(name, value);
        }
        return this;
    }

    @NotNull
    default public BasicHeaderValue add(@NotNull String value) {
        this.add(value, true);
        return this;
    }

    @NotNull
    default public BasicHeaderValue add(@NotNull String value, boolean check) {
        if (check && this.contains(value)) {
            return this;
        }
        this.getValues().add(value);
        return this;
    }

    @NotNull
    default public BasicHeaderValue remove(@NotNull String value) {
        this.getValues().remove(value);
        return this;
    }

    default public boolean contains(@NotNull String value) {
        for (String val : this.getValues()) {
            if (!value.equals(val)) continue;
            return true;
        }
        return false;
    }
}

