/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.http.status;

import de.linusdev.lutils.other.UnknownConstantException;
import org.jetbrains.annotations.NotNull;

public enum ResponseStatusCodeType {
    INFORMATION(100, 199),
    SUCCESSFUL(200, 299),
    REDIRECT(300, 399),
    CLIENT_ERROR(400, 499),
    SERVER_ERROR(500, 599);

    private final int statusCodeRangeStart;
    private final int statusCodeRangeEnd;

    @NotNull
    public static ResponseStatusCodeType of(int statusCode) {
        if (INFORMATION.isInRange(statusCode)) {
            return INFORMATION;
        }
        if (SUCCESSFUL.isInRange(statusCode)) {
            return SUCCESSFUL;
        }
        if (REDIRECT.isInRange(statusCode)) {
            return REDIRECT;
        }
        if (CLIENT_ERROR.isInRange(statusCode)) {
            return CLIENT_ERROR;
        }
        if (SERVER_ERROR.isInRange(statusCode)) {
            return SERVER_ERROR;
        }
        throw new UnknownConstantException(statusCode);
    }

    private ResponseStatusCodeType(int statusCodeRangeStart, int statusCodeRangeEnd) {
        this.statusCodeRangeStart = statusCodeRangeStart;
        this.statusCodeRangeEnd = statusCodeRangeEnd;
    }

    public boolean isInRange(int statusCode) {
        return statusCode >= this.statusCodeRangeStart && statusCode <= this.statusCodeRangeEnd;
    }
}

