/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws.control;

import de.linusdev.lutils.net.ws.control.ControlFrame;
import de.linusdev.lutils.net.ws.control.WSStatusCode;
import de.linusdev.lutils.net.ws.frame.AbstractFrame;
import de.linusdev.lutils.net.ws.frame.Frame;
import de.linusdev.lutils.net.ws.frame.OpCodes;
import de.linusdev.lutils.other.ByteUtils;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseFrame
implements AbstractFrame,
ControlFrame {
    @NotNull
    private final Frame frame;
    @Nullable
    private final Integer statusCode;
    @Nullable
    private final String reason;

    public CloseFrame(@NotNull Frame frame) {
        this.frame = frame;
        if (frame.length() == 0) {
            this.statusCode = null;
            this.reason = null;
            return;
        }
        if (frame.length() < 2) {
            throw new IllegalStateException("Illegal payload length for a close frame.");
        }
        byte[] payload = frame.getPayload();
        this.statusCode = ByteUtils.constructInt(payload[0], payload[1]);
        this.reason = frame.length() > 2 ? new String(payload, 2, frame.length() - 2, StandardCharsets.UTF_8) : null;
    }

    @Nullable
    public WSStatusCode statusCode() {
        return this.statusCode == null ? null : WSStatusCode.of(this.statusCode);
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @NotNull
    public OpCodes opcode() {
        return this.frame.opcode();
    }

    @Override
    public int length() {
        return this.frame.length();
    }

    @Override
    public boolean isFinal() {
        return this.frame.isFinal();
    }
}

