/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws.control.writable;

import de.linusdev.lutils.net.ws.control.ControlFrame;
import de.linusdev.lutils.net.ws.control.WSStatusCode;
import de.linusdev.lutils.net.ws.frame.OpCodes;
import de.linusdev.lutils.net.ws.frames.writable.WriteableFrame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WritableCloseFrame
implements WriteableFrame,
ControlFrame {
    private final byte @Nullable [] body;

    public WritableCloseFrame() {
        this(null, null);
    }

    public WritableCloseFrame(@Nullable WSStatusCode statusCode) {
        this(statusCode, null);
    }

    public WritableCloseFrame(@Nullable WSStatusCode statusCode, @Nullable String reason) {
        if (statusCode == null && reason != null) {
            throw new IllegalArgumentException("A close frame cannot contain a reason string without a status code.");
        }
        if (statusCode == null) {
            this.body = null;
            return;
        }
        if (reason == null) {
            this.body = new byte[]{(byte)(statusCode.code() & 0xFF), (byte)(statusCode.code() & 0xFF)};
            return;
        }
        byte[] stringBytes = reason.getBytes(StandardCharsets.UTF_8);
        this.body = new byte[stringBytes.length + 2];
        this.body[0] = (byte)(statusCode.code() & 0xFF);
        this.body[1] = (byte)(statusCode.code() & 0xFF);
        System.arraycopy(stringBytes, 0, this.body, 2, stringBytes.length);
        if (this.body.length > 125) {
            throw new IllegalArgumentException("A control frame body cannot be larger than 125bytes.");
        }
    }

    @Override
    @NotNull
    public OpCodes opcode() {
        return OpCodes.CLOSE;
    }

    @Override
    public int length() {
        return this.body == null ? 0 : this.body.length;
    }

    @Override
    @Nullable
    public InputStream stream() {
        return this.body == null ? null : new ByteArrayInputStream(this.body);
    }
}

