/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.net.ws.frame;

import de.linusdev.lutils.net.ws.control.CloseFrame;
import de.linusdev.lutils.net.ws.frame.OpCodes;
import de.linusdev.lutils.net.ws.frames.TextFrame;
import de.linusdev.lutils.net.ws.frames.writable.WriteableFrame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Frame
implements WriteableFrame {
    private final boolean fin;
    private final boolean rsv1;
    private final boolean rsv2;
    private final boolean rsv3;
    private final boolean masked;
    private final OpCodes opcode;
    private final int payloadLength;
    private final byte[] payload;

    public Frame(boolean fin, boolean rsv1, boolean rsv2, boolean rsv3, boolean masked, byte opcode, int payloadLength, byte[] payload) {
        this.fin = fin;
        this.rsv1 = rsv1;
        this.rsv2 = rsv2;
        this.rsv3 = rsv3;
        this.masked = masked;
        this.opcode = OpCodes.ofByte(opcode);
        this.payloadLength = payloadLength;
        this.payload = payload;
    }

    @Override
    public boolean isFinal() {
        return this.fin;
    }

    public boolean getReserved1() {
        return this.rsv1;
    }

    public boolean getReserved2() {
        return this.rsv2;
    }

    public boolean getReserved3() {
        return this.rsv3;
    }

    public boolean wasMasked() {
        return this.masked;
    }

    @Override
    @NotNull
    public OpCodes opcode() {
        return this.opcode;
    }

    @Override
    public int length() {
        return this.payloadLength;
    }

    @Override
    @Nullable
    public InputStream stream() {
        return new ByteArrayInputStream(this.payload);
    }

    @NotNull
    public CloseFrame toCloseFrame() {
        assert (this.opcode == OpCodes.CLOSE);
        return new CloseFrame(this);
    }

    @NotNull
    public TextFrame toTextFrame() {
        assert (this.opcode == OpCodes.TEXT_UTF8);
        return new TextFrame(this);
    }

    public byte[] getPayload() {
        return this.payload;
    }
}

