/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.os;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public enum OSType {
    LINUX("Linux", "linux"),
    WINDOWS("Windows", "windows"),
    UNKNOWN("Unknown", new String[0]);

    @NotNull
    private final String name;
    @NotNull
    private final @NotNull String @NotNull [] fixes;

    @NotNull
    public static OSType of(@NotNull String name) {
        name = name.toLowerCase(Locale.ROOT);
        for (OSType type : OSType.values()) {
            for (String fix : type.fixes) {
                if (!name.contains(fix)) continue;
                return type;
            }
        }
        return UNKNOWN;
    }

    private OSType(String name, String ... fix) {
        this.name = name;
        this.fixes = fix;
    }

    @NotNull
    public String getName() {
        return this.name;
    }
}

