/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.other.str;

import de.linusdev.lutils.other.str.Part;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ConstructableString {
    @NotNull
    private final @NotNull Part @NotNull [] parts;

    public ConstructableString(@NotNull @NotNull Part @NotNull [] parts) {
        this.parts = parts;
    }

    @NotNull
    public String construct(@NotNull Map<String, String> values) {
        StringBuilder sb = new StringBuilder();
        for (Part part : this.parts) {
            sb.append(part.get(values));
        }
        return sb.toString();
    }

    public static class Builder {
        @NotNull
        private final ArrayList<Part> parts = new ArrayList();

        public void add(@NotNull Part part) {
            this.parts.add(part);
        }

        public void addConstant(@NotNull String constant) {
            this.add(Part.constant(constant));
        }

        public void addPlaceholder(@NotNull String key) {
            this.add(Part.placeholder(key));
        }

        @NotNull
        public ConstructableString build() {
            return new ConstructableString((Part[])this.parts.toArray(Part[]::new));
        }
    }
}

