/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.version;

import de.linusdev.lutils.version.SimpleVersionImpl;
import org.jetbrains.annotations.NotNull;

public interface SimpleVersion
extends Comparable<SimpleVersion> {
    @NotNull
    public static SimpleVersion of(int major, int minor, int patch) {
        return new SimpleVersionImpl(major, minor, patch);
    }

    @NotNull
    public static SimpleVersion of(@NotNull String simpleVersion) {
        String[] parts = simpleVersion.split("\\.");
        return SimpleVersion.of(Integer.parseInt(parts[0]), parts.length >= 2 ? Integer.parseInt(parts[1]) : 0, parts.length >= 3 ? Integer.parseInt(parts[2]) : 0);
    }

    public int major();

    public int minor();

    public int patch();

    @NotNull
    default public String getAsUserFriendlyString() {
        return this.major() + "." + this.minor() + "." + this.patch();
    }

    @Override
    default public int compareTo(@NotNull SimpleVersion other) {
        if (this.major() > other.major()) {
            return 3;
        }
        if (this.major() < other.major()) {
            return -3;
        }
        if (this.minor() > other.minor()) {
            return 2;
        }
        if (this.minor() < other.minor()) {
            return -2;
        }
        if (this.patch() > other.patch()) {
            return 1;
        }
        if (this.patch() < other.patch()) {
            return -1;
        }
        return 0;
    }
}

