/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.mixin.client;

import de.linusdev.OneWorldFolderModClient;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resource.FileResourcePackProvider;
import net.minecraft.resource.ResourcePackManager;
import net.minecraft.resource.ResourcePackProfile;
import net.minecraft.resource.ResourcePackProvider;
import net.minecraft.resource.ResourcePackSource;
import net.minecraft.resource.ResourceType;
import net.minecraft.util.path.SymlinkFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ResourcePackManager.class})
public abstract class ResourcePackManagerMixin {
    @Unique
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ResourcePackManagerMixin");
    @Shadow
    @Final
    @Mutable
    private Set<ResourcePackProvider> providers;
    @Shadow
    private Map<String, ResourcePackProfile> profiles;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void construct(ResourcePackProvider[] resourcePackProviders, CallbackInfo info) {
        this.providers = new LinkedHashSet<ResourcePackProvider>(this.providers);
        if (OneWorldFolderModClient.config == null) {
            return;
        }
        for (String additionalPackDir : OneWorldFolderModClient.config.getAdditionalPackDirs()) {
            this.providers.add((ResourcePackProvider)new FileResourcePackProvider(Paths.get(additionalPackDir, new String[0]), ResourceType.CLIENT_RESOURCES, ResourcePackSource.NONE, new SymlinkFinder(path -> true)));
        }
    }
}

