/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.oneworldfolder.config;

import de.linusdev.OneWorldFolderModClient;
import de.linusdev.data.parser.JsonParser;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.data.so.SOData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import net.minecraft.client.MinecraftClient;
import org.jetbrains.annotations.NotNull;

public class Config {
    @NotNull
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final String CONFIG_DIR_NAME = "config";
    public static final String OWF_CONFIG_DIR_NAME = "oneworldfolder";
    public static final String OWF_CONFIG_FILE_NAME = "oneworldfolder.json";
    public static final String EXTERNAL_SAVES_DIR_KEY = "external_saves_directory";
    public static final String AUTO_DETECT = "--auto-detect";
    public static final String PRIORITY_KEY = "priority";
    public static final String SWAP_OWF_BUTTON_AND_SINGLEPLAYER_BUTTON_OLD_KEY = "replace_owf_and_singleplayer_button";
    public static final String SWAP_OWF_BUTTON_AND_SINGLEPLAYER_BUTTON_KEY = "swap_owf_and_singleplayer_button";
    public static final String REPLACE_SINGLEPLAYER_BUTTON_KEY = "replace_singleplayer_button";
    public static final String ADDITIONAL_PACKS_DIRS_KEY = "additional_resourcepacks_dirs";
    @NotNull
    private final Path configFile;
    private final boolean supportsCustomLevelStorage;
    private boolean cannotFindMinecraftFolder;
    private boolean autodetectSavesPath = false;
    private final Path externalMinecraftDirectory;
    private final String externalSavesDirName;
    private final int priority;
    private final boolean swapOwfButtonAndSingleplayerButton;
    private final boolean replaceSingleplayerButton;
    private final List<String> additionalPackDirs;
    private static Map<String, String> envMap = System.getenv();

    @NotNull
    public static Config from(Path ... locations) throws IOException, ParseException {
        Config highestPriority = null;
        for (Path location : locations) {
            Path configFile;
            if (location == null || !Files.exists(configFile = location.resolve(CONFIG_DIR_NAME).resolve(OWF_CONFIG_DIR_NAME).resolve(OWF_CONFIG_FILE_NAME), new LinkOption[0])) continue;
            Config c = new Config(configFile);
            c.store();
            if (highestPriority != null && highestPriority.getPriority() >= c.getPriority()) continue;
            highestPriority = c;
        }
        if (highestPriority != null) {
            return highestPriority;
        }
        return new Config(MinecraftClient.getInstance().runDirectory.toPath().resolve(CONFIG_DIR_NAME).resolve(OWF_CONFIG_DIR_NAME).resolve(OWF_CONFIG_FILE_NAME)).store();
    }

    public Config(@NotNull Path configFile) throws IOException, ParseException {
        Path externalSavesDir;
        this.configFile = configFile;
        SOData data = SOData.newOrderedDataWithKnownSize(10);
        if (Files.exists(configFile, new LinkOption[0])) {
            data = JSON_PARSER.parseStream(Files.newInputStream(configFile, new OpenOption[0]));
        }
        this.externalMinecraftDirectory = (externalSavesDir = (Path)data.getContainer(EXTERNAL_SAVES_DIR_KEY).castAndConvert(string -> {
            if (string == null || string.equals(AUTO_DETECT)) {
                this.autodetectSavesPath = true;
                Path md = OneWorldFolderModClient.getDefaultMinecraftFolder();
                return md == null ? null : md.resolve("saves");
            }
            return Paths.get(Config.expandEnvVars(string), new String[0]);
        }).get()) == null ? null : externalSavesDir.getParent();
        this.externalSavesDirName = externalSavesDir == null ? null : externalSavesDir.getFileName().toString();
        this.priority = data.getNumberAsInt(PRIORITY_KEY, key -> -1);
        boolean oldSwapOwfButtonAndSingleplayerButton = data.getOrDefaultBoth(SWAP_OWF_BUTTON_AND_SINGLEPLAYER_BUTTON_OLD_KEY, false);
        this.swapOwfButtonAndSingleplayerButton = data.getOrDefaultBoth(SWAP_OWF_BUTTON_AND_SINGLEPLAYER_BUTTON_KEY, oldSwapOwfButtonAndSingleplayerButton);
        this.replaceSingleplayerButton = data.getOrDefaultBoth(REPLACE_SINGLEPLAYER_BUTTON_KEY, false);
        this.supportsCustomLevelStorage = this.externalMinecraftDirectory != null && Files.exists(this.externalMinecraftDirectory, new LinkOption[0]);
        this.cannotFindMinecraftFolder = this.externalMinecraftDirectory == null;
        this.additionalPackDirs = data.get(ADDITIONAL_PACKS_DIRS_KEY) != null ? (List)data.getContainer(ADDITIONAL_PACKS_DIRS_KEY).asList().cast().get() : List.of();
    }

    public static String expandEnvVars(String text) {
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            text = text.replaceAll("\\$\\{" + key + "\\}", value);
        }
        return text;
    }

    public boolean isSupportsCustomLevelStorage() {
        return this.supportsCustomLevelStorage;
    }

    public boolean isCannotFindMinecraftFolder() {
        return this.cannotFindMinecraftFolder;
    }

    public Path getExternalMinecraftDirectory() {
        return this.externalMinecraftDirectory;
    }

    public String getExternalSavesDirName() {
        return this.externalSavesDirName;
    }

    public boolean isSwapOwfButtonAndSingleplayerButton() {
        return this.swapOwfButtonAndSingleplayerButton;
    }

    public boolean isReplaceSingleplayerButton() {
        return this.replaceSingleplayerButton;
    }

    public int getPriority() {
        return this.priority;
    }

    @NotNull
    public Path getConfigFile() {
        return this.configFile;
    }

    public List<String> getAdditionalPackDirs() {
        return this.additionalPackDirs;
    }

    public Config store() throws IOException {
        if (!Files.exists(this.configFile.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
        }
        SOData data = SOData.newOrderedDataWithKnownSize(10);
        data.add(EXTERNAL_SAVES_DIR_KEY, this.autodetectSavesPath ? AUTO_DETECT : this.externalMinecraftDirectory.resolve(this.externalSavesDirName).toString());
        data.add(PRIORITY_KEY, this.priority);
        data.add(SWAP_OWF_BUTTON_AND_SINGLEPLAYER_BUTTON_KEY, this.swapOwfButtonAndSingleplayerButton);
        data.add(REPLACE_SINGLEPLAYER_BUTTON_KEY, this.replaceSingleplayerButton);
        data.add(ADDITIONAL_PACKS_DIRS_KEY, this.additionalPackDirs);
        BufferedWriter writer = Files.newBufferedWriter(this.configFile, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        JSON_PARSER.writeData(writer, data);
        ((Writer)writer).close();
        return this;
    }
}

