package de.linusdev;

import com.mojang.logging.LogUtils;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.mixin.client.MinecraftClientAccessor;
import de.linusdev.oneworldfolder.ITitleScreenMixin;
import de.linusdev.oneworldfolder.config.Config;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_442;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class OneWorldFolderModClient implements ClientModInitializer {

	public static final class_2960 OWF_TITLE_SCREEN_IDENTIFIER = class_2960.method_60655("oneworldfolder", "titlescreen");
	public static final class_2960 OWF_ICON_ID = class_2960.method_60655("oneworldfolder", "icon/owf-icon-1024");
	public static final class_2960 NO_SMALL_OWF_ICON_ID = class_2960.method_60655("oneworldfolder", "icon/no-small-owf-icon-1024");

	public static class_32 customLevelStorage;
	public static boolean useCustomLevelStorage = false;

	public static Config config = reloadConfig();

	@Override
	public void onInitializeClient() {
		if(config == null) return;

		if(config.isSupportsCustomLevelStorage()) {
			customLevelStorage = new class_32(
					config.getExternalMinecraftDirectory().resolve(config.getExternalSavesDirName()),
					config.getExternalMinecraftDirectory().resolve("backups"),
					class_32.method_52235(config.getExternalMinecraftDirectory().resolve("allowed_symlinks.txt")),
					((MinecraftClientAccessor)class_310.method_1551()).getDataFixer()
			);
		}

		ScreenEvents.AFTER_INIT.register(OWF_TITLE_SCREEN_IDENTIFIER, (client, screen, scaledWidth, scaledHeight) -> {
			if(screen instanceof class_442) {
				((ITitleScreenMixin) screen).oneworldfolder$addCustomButton();
			}
		});
		ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, OWF_TITLE_SCREEN_IDENTIFIER);
	}

	public static Config reloadConfig() {
		try {
			return config = Config.from(getDefaultMinecraftFolder(), class_310.method_1551().field_1697.toPath());
		} catch (IOException | ParseException e) {
				LogUtils.getLogger().error("Cannot Load config: {}", e.getMessage());
			return null;
		}
	}

	public static @Nullable Path getDefaultMinecraftFolder() {
		String OS = System.getProperty("os.name").toLowerCase();

		if (OS.contains("win")) {
			return Paths.get(System.getenv("APPDATA"), ".minecraft");
		} else if (OS.contains("nix") || OS.contains("nux")) {
			return Paths.get(System.getProperty("user.home"), ".minecraft");
		} else {
			return null;
		}
	}
}
