package de.linusdev.mixin.client;

import de.linusdev.OneWorldFolderModClient;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_8580;
import net.minecraft.resource.*;
import org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@Mixin(class_3283.class)
public abstract class ResourcePackManagerMixin {
	@Unique
	private static final Logger LOGGER = LoggerFactory.getLogger("ResourcePackManagerMixin");

	@Shadow
	@Final
	@Mutable
    private Set<class_3285> providers;

	@Shadow
	private Map<String, class_3288> profiles;

	@Inject(method = "<init>", at = @At("RETURN"))
	public void construct(class_3285[] resourcePackProviders, CallbackInfo info) {
		// Use a LinkedHashSet to preserve ordering
		providers = new LinkedHashSet<>(providers);

		if(OneWorldFolderModClient.config == null) return;

		for (String additionalPackDir : OneWorldFolderModClient.config.getAdditionalPackDirs()) {
			providers.add(new class_3279(
					Paths.get(additionalPackDir),
					class_3264.field_14188,
					class_5352.field_25347,
					new class_8580(path -> true)
			));
		}

	}
}