/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev;

import com.mojang.logging.LogUtils;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.mixin.client.MinecraftClientAccessor;
import de.linusdev.oneworldfolder.ITitleScreenMixin;
import de.linusdev.oneworldfolder.config.Config;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_442;
import org.jetbrains.annotations.Nullable;

public class OneWorldFolderModClient
implements ClientModInitializer {
    public static final class_2960 OWF_TITLE_SCREEN_IDENTIFIER = class_2960.method_60655((String)"oneworldfolder", (String)"titlescreen");
    public static final class_2960 OWF_ICON_ID = class_2960.method_60655((String)"oneworldfolder", (String)"icon/owf-icon-1024");
    public static final class_2960 NO_SMALL_OWF_ICON_ID = class_2960.method_60655((String)"oneworldfolder", (String)"icon/no-small-owf-icon-1024");
    public static class_32 customLevelStorage;
    public static boolean useCustomLevelStorage;
    public static Config config;

    public void onInitializeClient() {
        if (config == null) {
            return;
        }
        if (config.isSupportsCustomLevelStorage()) {
            customLevelStorage = new class_32(config.getExternalMinecraftDirectory().resolve(config.getExternalSavesDirName()), config.getExternalMinecraftDirectory().resolve("backups"), class_32.method_52235((Path)config.getExternalMinecraftDirectory().resolve("allowed_symlinks.txt")), ((MinecraftClientAccessor)class_310.method_1551()).getDataFixer());
        }
        ScreenEvents.AFTER_INIT.register(OWF_TITLE_SCREEN_IDENTIFIER, (client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_442) {
                ((ITitleScreenMixin)screen).oneworldfolder$addCustomButton();
            }
        });
        ScreenEvents.AFTER_INIT.addPhaseOrdering(Event.DEFAULT_PHASE, OWF_TITLE_SCREEN_IDENTIFIER);
    }

    public static Config reloadConfig() {
        try {
            config = Config.from(OneWorldFolderModClient.getDefaultMinecraftFolder(), class_310.method_1551().field_1697.toPath());
            return config;
        }
        catch (ParseException | IOException e) {
            LogUtils.getLogger().error("Cannot Load config: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static Path getDefaultMinecraftFolder() {
        String OS = System.getProperty("os.name").toLowerCase();
        if (OS.contains("win")) {
            return Paths.get(System.getProperty("user.home"), "AppData", "Roaming", ".minecraft");
        }
        if (OS.contains("nix") || OS.contains("nux")) {
            return Paths.get(System.getProperty("user.home"), ".minecraft");
        }
        return null;
    }

    static {
        useCustomLevelStorage = false;
        config = OneWorldFolderModClient.reloadConfig();
    }
}

