/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.container;

import de.linusdev.data.AbstractData;
import de.linusdev.data.container.Container;
import de.linusdev.data.container.ListContainer;
import de.linusdev.data.container.ListContainerImpl;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerImpl<K, V, O>
implements Container<K, V, O> {
    @NotNull
    private final AbstractData<K, V> parentData;
    @NotNull
    private final K key;
    @Nullable
    private final O value;
    private final boolean exists;

    @Contract(pure=true)
    public ContainerImpl(@NotNull AbstractData<K, V> parentData, @NotNull K key, @Nullable O value, boolean exists) {
        this.parentData = parentData;
        this.key = key;
        this.value = value;
        this.exists = exists;
    }

    @Override
    public O get() {
        return this.value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    @NotNull
    public K getKey() {
        return this.key;
    }

    @Override
    @NotNull
    public AbstractData<K, V> getParentData() {
        return this.parentData;
    }

    @Override
    @NotNull
    public <N> Container<K, V, N> createNewContainer(@Nullable N newValue) {
        return new ContainerImpl<K, V, N>(this.parentData, this.key, newValue, this.exists);
    }

    @Override
    @NotNull
    public <T> ListContainer<T> createNewListContainer(@Nullable List<T> newValue) {
        return new ListContainerImpl<T>(newValue, this.exists);
    }
}

