/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.parser;

import de.linusdev.data.parser.ParseTracker;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.data.parser.exceptions.ParseValueException;
import de.linusdev.data.parser.exceptions.UnexpectedCharacterException;
import de.linusdev.data.parser.exceptions.UnexpectedEndException;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonReader {
    private final Reader reader;
    private int pushBack = -1;

    public JsonReader(Reader reader) {
        this.reader = reader;
    }

    public void pushBack(int i) {
        this.pushBack = i;
    }

    public int read(@NotNull ParseTracker tracker) throws IOException {
        int i;
        if (this.pushBack != -1) {
            int i2 = this.pushBack;
            this.pushBack = -1;
            return i2;
        }
        while ((i = this.reader.read()) != -1) {
            if (i == 10) {
                tracker.nextLine();
                continue;
            }
            if (i <= 32) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public Object readValue(@NotNull ParseTracker tracker) throws IOException, ParseException {
        StringBuilder str = new StringBuilder(50);
        int i = this.read(tracker);
        while (i != -1) {
            if (i == 44 || i == 125 || i == 93) {
                this.pushBack(i);
                String valueString = str.toString();
                if (valueString.isEmpty()) {
                    throw new UnexpectedCharacterException((char)i, tracker);
                }
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
                if (valueString.equalsIgnoreCase("null")) {
                    return null;
                }
                try {
                    return NumberFormat.getNumberInstance(Locale.ENGLISH).parse(valueString);
                }
                catch (java.text.ParseException e) {
                    throw new ParseValueException(e, valueString, tracker);
                }
            }
            str.append((char)i);
            i = this.read(tracker);
        }
        throw new UnexpectedEndException(tracker);
    }

    public String readString(boolean allowNewLine, @NotNull ParseTracker tracker) throws IOException, UnexpectedEndException, UnexpectedCharacterException {
        int i;
        StringBuilder str = new StringBuilder(1024);
        boolean escaped = false;
        char[] chars = new char[4];
        while ((i = this.reader.read()) != -1) {
            char c = (char)i;
            if (escaped) {
                escaped = false;
                if (c == 'n') {
                    str.append('\n');
                    continue;
                }
                if (c == 'f') {
                    str.append('\f');
                    continue;
                }
                if (c == 'r') {
                    str.append('\r');
                    continue;
                }
                if (c == 't') {
                    str.append('\t');
                    continue;
                }
                if (c == 'b') {
                    str.append('\b');
                    continue;
                }
                if (c == '\\') {
                    str.append('\\');
                    continue;
                }
                if (c == '\"') {
                    str.append('\"');
                    continue;
                }
                if (c == 'u') {
                    if (this.reader.read(chars) != 4) {
                        throw new UnexpectedEndException(tracker);
                    }
                    str.append((char)Integer.parseInt(new String(chars), 16));
                    continue;
                }
                str.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                return str.toString();
            }
            if (c == '\n') {
                if (!allowNewLine) {
                    throw new UnexpectedCharacterException(c, tracker);
                }
                str.append(c);
                tracker.nextLine();
                continue;
            }
            str.append(c);
        }
        throw new UnexpectedEndException(tracker);
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException cannotClose) {
            System.err.println("Cannot close reader!");
            cannotClose.printStackTrace();
        }
    }
}

