/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.parser;

import de.linusdev.data.AbstractData;
import de.linusdev.data.Datable;
import de.linusdev.data.entry.Entry;
import de.linusdev.data.implemantations.SODataListImpl;
import de.linusdev.data.parser.ParseHelper;
import de.linusdev.data.parser.ParseTracker;
import de.linusdev.data.parser.SimpleEntry;
import de.linusdev.data.parser.SpaceOffsetTracker;
import de.linusdev.data.parser.exceptions.ParseException;
import de.linusdev.data.parser.exceptions.ParseValueException;
import de.linusdev.data.parser.exceptions.UnexpectedCharacterException;
import de.linusdev.data.parser.exceptions.UnexpectedEndException;
import de.linusdev.data.so.SAOEntryImpl;
import de.linusdev.lutils.interfaces.Simplifiable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class OldJsonParser {
    private static final char BYTE_TOKEN = 'B';
    private static final char SHORT_TOKEN = 'S';
    private static final char INTEGER_TOKEN = 'I';
    private static final char LONG_TOKEN = 'L';
    private static final char FLOAT_TOKEN = 'F';
    private static final char DOUBLE_TOKEN = 'D';
    private Reader reader = null;
    private ParseTracker tracker = null;
    private StringBuilder str = null;
    private Writer writer;
    private SpaceOffsetTracker offset = null;
    private String offsetString = "  ";
    private boolean identifyNumberValues = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SODataListImpl readDataFromResourceFile(String resource) throws IOException, ParseException, NullPointerException {
        SODataListImpl data;
        try {
            InputStream in = OldJsonParser.class.getClassLoader().getResourceAsStream(resource);
            if (in == null) {
                SODataListImpl sODataListImpl = null;
                return sODataListImpl;
            }
            this.reader = new BufferedReader(new InputStreamReader(in));
            this.tracker = new ParseTracker();
            data = this.readDataFromStream(this.nextFromStream(true));
        }
        finally {
            this.reader.close();
        }
        return data;
    }

    public SODataListImpl readDataFromFile(Path filePath) throws IOException, ParseException {
        SODataListImpl data;
        try {
            this.reader = Files.newBufferedReader(filePath);
            this.tracker = new ParseTracker();
            data = this.readDataFromStream(this.nextFromStream(true));
        }
        finally {
            this.reader.close();
        }
        return data;
    }

    public SODataListImpl readDataFromReader(Reader reader) throws ParseException, IOException {
        return this.readDataFromReader(reader, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SODataListImpl readDataFromReader(Reader reader, boolean autoArray, @Nullable String arrayKey) throws ParseException, IOException {
        SODataListImpl data;
        try {
            this.reader = reader;
            this.tracker = new ParseTracker();
            char c = this.nextFromStream(true);
            if (c == '[' && autoArray) {
                data = new SODataListImpl((List<Entry<String, Object>>)new LinkedList<Entry<String, Object>>());
                SAOEntryImpl<Object> entry = new SAOEntryImpl<Object>(arrayKey);
                c = this.readArrayFromReader(reader, c, entry);
                data.addEntry(entry);
            } else {
                data = this.readDataFromStream(c);
            }
        }
        finally {
            reader.close();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList readArrayFromReader(Reader reader) throws IOException, ParseException {
        this.reader = reader;
        this.tracker = new ParseTracker();
        try {
            SimpleEntry entry = new SimpleEntry();
            char c = this.readArrayFromReader(reader, this.nextFromStream(true), entry);
            ArrayList arrayList = (ArrayList)entry.getValue();
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    private char readArrayFromReader(Reader reader, char c, Entry<?, Object> entry) throws IOException, ParseException {
        if (c != '[') {
            throw new UnexpectedCharacterException(c, this.tracker);
        }
        c = this.readValueFromStream(c, entry, true);
        return c;
    }

    public void writeData(AbstractData<?, ?> data, Writer writer) throws IOException {
        this.writer = writer;
        this.offset = new SpaceOffsetTracker(this.offsetString);
        if (data == null) {
            data = new SODataListImpl((List<Entry<String, Object>>)new ArrayList<Entry<String, Object>>(0));
        }
        this.writeJson(data);
    }

    public StringBuilder getJsonString(AbstractData<?, ?> data) {
        this.str = new StringBuilder();
        this.offset = new SpaceOffsetTracker(this.offsetString);
        return this.generateJsonString(data);
    }

    public void setOffsetString(String offsetString) {
        this.offsetString = offsetString;
    }

    public void setIdentifyNumberValues(boolean identifyNumberValues) {
        this.identifyNumberValues = identifyNumberValues;
    }

    private SODataListImpl readDataFromStream(char c) throws IOException, ParseException {
        SODataListImpl data = new SODataListImpl((List<Entry<String, Object>>)new LinkedList<Entry<String, Object>>());
        if (c != '{') {
            throw new UnexpectedCharacterException(c, this.tracker);
        }
        c = this.nextFromStream(true);
        if (c == '}') {
            return data;
        }
        while (true) {
            if (c != '\"') {
                throw new UnexpectedCharacterException(c, this.tracker);
            }
            SAOEntryImpl<Object> e = new SAOEntryImpl<Object>(this.readKeyFromStream());
            c = this.nextFromStream(false);
            if (c != ':') {
                throw new UnexpectedCharacterException(c, this.tracker);
            }
            c = this.readValueFromStream(this.nextFromStream(true), e);
            data.addEntry(e);
            if (c != ',') break;
            c = this.nextFromStream(true);
        }
        if (c != '}') {
            throw new UnexpectedCharacterException(c, this.tracker);
        }
        return data;
    }

    private char readValueFromStream(char c, Entry<?, Object> entry) throws ParseException, IOException {
        return this.readValueFromStream(c, entry, false);
    }

    private char readValueFromStream(char c, Entry<?, Object> entry, boolean ignoreUnexpectedEndAfterArray) throws ParseException, IOException {
        if (c == '\"') {
            entry.setValue(this.intrudeStringValueFrom());
            return this.nextFromStream(true);
        }
        if (c == '{') {
            entry.setValue(this.readDataFromStream(c));
            return this.nextFromStream(true);
        }
        if (c == '[') {
            c = this.nextFromStream(true);
            if (c == ']') {
                entry.setValue(new ArrayList());
                return this.nextFromStream(true, ignoreUnexpectedEndAfterArray);
            }
            ArrayList<Object> list = new ArrayList<Object>();
            while (c != ']') {
                if (c == ',') {
                    throw new UnexpectedCharacterException(c, this.tracker);
                }
                SimpleEntry e = new SimpleEntry();
                c = this.readValueFromStream(c, e);
                list.add(e.getValue());
                if (c == ']') break;
                if (c != ',') {
                    throw new UnexpectedCharacterException(c, this.tracker);
                }
                c = this.nextFromStream(true);
            }
            entry.setValue(list);
            return this.nextFromStream(true, ignoreUnexpectedEndAfterArray);
        }
        StringBuilder value = new StringBuilder();
        c = this.readRawValueFromStream(c, value);
        if (value.toString().trim().equalsIgnoreCase("true")) {
            entry.setValue(true);
        } else if (value.toString().trim().equalsIgnoreCase("false")) {
            entry.setValue(false);
        } else if (value.toString().trim().equalsIgnoreCase("null")) {
            entry.setValue(null);
        } else {
            try {
                switch (value.charAt(value.length() - 1)) {
                    case 'B': {
                        entry.setValue(Byte.parseByte(value.substring(0, value.length() - 1)));
                        break;
                    }
                    case 'S': {
                        entry.setValue(Short.parseShort(value.substring(0, value.length() - 1)));
                        break;
                    }
                    case 'I': {
                        entry.setValue(Integer.parseInt(value.substring(0, value.length() - 1)));
                        break;
                    }
                    case 'L': {
                        entry.setValue(Long.parseLong(value.substring(0, value.length() - 1)));
                        break;
                    }
                    case 'F': {
                        entry.setValue(Float.valueOf(Float.parseFloat(value.substring(0, value.length() - 1))));
                        break;
                    }
                    case 'D': {
                        entry.setValue(Double.parseDouble(value.substring(0, value.length() - 1)));
                        break;
                    }
                    default: {
                        String vs = value.toString();
                        entry.setValue(NumberFormat.getNumberInstance(Locale.ENGLISH).parse(vs));
                        break;
                    }
                }
            }
            catch (NumberFormatException | java.text.ParseException e) {
                throw new ParseValueException(e, value.toString(), this.tracker);
            }
        }
        return c;
    }

    private char readRawValueFromStream(char c, StringBuilder value) throws IOException, UnexpectedEndException, UnexpectedCharacterException {
        int read;
        value.append(c);
        while ((read = this.reader.read()) != -1) {
            c = (char)read;
            if (c == '\n') {
                this.tracker.nextLine();
                c = this.nextFromStream(true);
                if (c == ']' || c == '}' || c == ',') {
                    return c;
                }
                throw new UnexpectedCharacterException(c, this.tracker);
            }
            if (c == ']' || c == '}' || c == ',') {
                return c;
            }
            value.append(c);
        }
        throw new UnexpectedEndException();
    }

    private String intrudeStringValueFrom() throws UnexpectedCharacterException, IOException, UnexpectedEndException {
        StringBuilder str = new StringBuilder();
        int read = this.reader.read();
        boolean escaped = false;
        while (read != -1) {
            char c = (char)read;
            if (escaped) {
                escaped = false;
                switch (c) {
                    case 'n': {
                        str.append('\n');
                        break;
                    }
                    case 'f': {
                        str.append('\f');
                        break;
                    }
                    case 'r': {
                        str.append('\r');
                        break;
                    }
                    case 't': {
                        str.append('\t');
                        break;
                    }
                    case 'b': {
                        str.append('\b');
                        break;
                    }
                    case '\\': {
                        str.append('\\');
                        break;
                    }
                    case '\"': {
                        str.append('\"');
                        break;
                    }
                    case 'u': {
                        StringBuilder esc = new StringBuilder(4);
                        for (int i = 0; i < 4; ++i) {
                            read = this.reader.read();
                            if (read == -1) {
                                throw new UnexpectedEndException();
                            }
                            esc.append((char)read);
                        }
                        str.append((char)Integer.parseInt(esc.toString(), 16));
                        break;
                    }
                    default: {
                        str.append(c);
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\\': {
                        escaped = true;
                        break;
                    }
                    case '\"': {
                        return str.toString();
                    }
                    case '\n': {
                        throw new UnexpectedCharacterException(c, this.tracker);
                    }
                    default: {
                        str.append(c);
                    }
                }
            }
            read = this.reader.read();
        }
        throw new UnexpectedEndException();
    }

    private String readKeyFromStream() throws IOException, UnexpectedCharacterException, UnexpectedEndException {
        StringBuilder str = new StringBuilder();
        int read = this.reader.read();
        while (read != -1) {
            char c = (char)read;
            switch (c) {
                case '\"': {
                    return str.toString();
                }
                case '\n': {
                    throw new UnexpectedCharacterException(c, this.tracker);
                }
            }
            str.append(c);
            read = this.reader.read();
        }
        throw new UnexpectedEndException();
    }

    private char nextFromStream(boolean allowNewLine) throws IOException, UnexpectedEndException, UnexpectedCharacterException {
        return this.nextFromStream(allowNewLine, false);
    }

    private char nextFromStream(boolean allowNewLine, boolean ignoreUnexpectedEnd) throws IOException, UnexpectedEndException, UnexpectedCharacterException {
        int read = this.reader.read();
        while (read != -1) {
            char c = (char)read;
            switch (c) {
                case '\t': 
                case ' ': {
                    break;
                }
                case '\n': {
                    if (allowNewLine) {
                        this.tracker.nextLine();
                        break;
                    }
                    throw new UnexpectedCharacterException(c, this.tracker);
                }
                default: {
                    if (c <= '\u001f') break;
                    return c;
                }
            }
            read = this.reader.read();
        }
        if (ignoreUnexpectedEnd) {
            return 'a';
        }
        throw new UnexpectedEndException();
    }

    private StringBuilder generateJsonString(@NotNull AbstractData<?, ?> data) {
        this.str.append('{');
        this.offset.add();
        boolean first = true;
        for (Entry entry : data) {
            if (!first) {
                this.str.append(',');
            } else {
                first = false;
            }
            this.str.append('\n').append(this.offset);
            this.str.append('\"').append(entry.getKey()).append("\": ");
            this.jsonValueJsonString(entry.getValue());
        }
        this.str.append('\n');
        this.offset.remove();
        this.str.append(this.offset).append('}');
        return this.str;
    }

    private void jsonValueJsonString(@Nullable Object value) {
        if (value == null) {
            this.str.append("null");
        } else if (value instanceof Datable) {
            this.generateJsonString(((Datable)value).getData());
        } else if (value instanceof Simplifiable) {
            this.jsonValueJsonString(((Simplifiable)value).simplify());
        } else if (value instanceof String) {
            this.str.append('\"');
            ParseHelper.escape2((String)value, this.str);
            this.str.append('\"');
        } else if (value instanceof Boolean) {
            this.str.append(value.toString());
        } else if (value instanceof Integer) {
            this.str.append(value.toString());
            if (this.identifyNumberValues) {
                this.str.append('I');
            }
        } else if (value instanceof Long) {
            this.str.append(value.toString());
            if (this.identifyNumberValues) {
                this.str.append('L');
            }
        } else if (value instanceof Byte) {
            this.str.append(value);
            if (this.identifyNumberValues) {
                this.str.append('B');
            }
        } else if (value instanceof Short) {
            this.str.append(value);
            if (this.identifyNumberValues) {
                this.str.append('S');
            }
        } else if (value instanceof Double) {
            this.str.append(value.toString());
            if (this.identifyNumberValues) {
                this.str.append('D');
            }
        } else if (value instanceof Float) {
            this.str.append(value.toString());
            if (this.identifyNumberValues) {
                this.str.append('F');
            }
        } else if (value instanceof Collection) {
            this.str.append('[').append('\n');
            this.offset.add();
            boolean first = true;
            for (Object o : (Collection)value) {
                if (!first) {
                    this.str.append(',').append('\n');
                } else {
                    first = false;
                }
                this.str.append(this.offset);
                this.jsonValueJsonString(o);
            }
            this.str.append('\n');
            this.offset.remove();
            this.str.append(this.offset).append(']');
        } else if (value instanceof Object[]) {
            this.jsonValueJsonString((Object[])value);
        } else if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                byte[] a = (byte[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.jsonValueJsonString(o);
            } else if (value instanceof short[]) {
                short[] a = (short[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.jsonValueJsonString(o);
            } else if (value instanceof int[]) {
                int[] a = (int[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.jsonValueJsonString(o);
            } else if (value instanceof long[]) {
                long[] a = (long[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.jsonValueJsonString(o);
            } else if (value instanceof float[]) {
                float[] a = (float[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = Float.valueOf(a[i]);
                }
                this.jsonValueJsonString(o);
            } else if (value instanceof double[]) {
                double[] a = (double[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.jsonValueJsonString(o);
            }
        } else {
            this.str.append('\"');
            ParseHelper.escape2(value.toString(), this.str);
            this.str.append('\"');
        }
    }

    private void jsonValueJsonString(@Nullable Object[] value) {
        this.str.append('[').append('\n');
        this.offset.add();
        boolean first = true;
        for (Object o : value) {
            if (!first) {
                this.str.append(',').append('\n');
            } else {
                first = false;
            }
            this.str.append(this.offset);
            this.jsonValueJsonString(o);
        }
        this.str.append('\n');
        this.offset.remove();
        this.str.append(this.offset).append(']');
    }

    private void writeJson(@Nullable AbstractData<?, ?> data) throws IOException {
        if (data == null) {
            data = new SODataListImpl((List<Entry<String, Object>>)new ArrayList<Entry<String, Object>>(0));
        }
        this.writer.append('{');
        this.offset.add();
        boolean first = true;
        for (Entry entry : data) {
            if (!first) {
                this.writer.append(',');
            } else {
                first = false;
            }
            this.writer.append('\n').append(this.offset.toString());
            this.writer.append('\"').append(Objects.toString(entry.getKey())).append("\": ");
            this.writeJsonValue(entry.getValue());
        }
        this.writer.append('\n');
        this.offset.remove();
        this.writer.append(this.offset.toString()).append('}');
    }

    private void writeJsonValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writer.append("null");
        } else if (value instanceof Datable) {
            this.writeJson(((Datable)value).getData());
        } else if (value instanceof Simplifiable) {
            this.writeJsonValue(((Simplifiable)value).simplify());
        } else if (value instanceof String) {
            this.writer.append('\"');
            ParseHelper.escape2((String)value, this.writer);
            this.writer.append('\"');
        } else if (value instanceof Boolean) {
            this.writer.append(value.toString());
        } else if (value instanceof Integer) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('I');
            }
        } else if (value instanceof Long) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('L');
            }
        } else if (value instanceof Byte) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('B');
            }
        } else if (value instanceof Short) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('S');
            }
        } else if (value instanceof Double) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('D');
            }
        } else if (value instanceof Float) {
            this.writer.append(value.toString());
            if (this.identifyNumberValues) {
                this.writer.append('F');
            }
        } else if (value instanceof Collection) {
            this.writer.append('[').append('\n');
            this.offset.add();
            boolean first = true;
            for (Object o : (Collection)value) {
                if (!first) {
                    this.writer.append(',').append('\n');
                } else {
                    first = false;
                }
                this.writer.append(this.offset.toString());
                this.writeJsonValue(o);
            }
            this.writer.append('\n');
            this.offset.remove();
            this.writer.append(this.offset.toString()).append(']');
        } else if (value instanceof Object[]) {
            this.writeJsonValue((Object[])value);
        } else if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                byte[] a = (byte[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(o);
            } else if (value instanceof short[]) {
                short[] a = (short[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(o);
            } else if (value instanceof int[]) {
                int[] a = (int[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(o);
            } else if (value instanceof long[]) {
                long[] a = (long[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(o);
            } else if (value instanceof float[]) {
                float[] a = (float[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = Float.valueOf(a[i]);
                }
                this.writeJsonValue(o);
            } else if (value instanceof double[]) {
                double[] a = (double[])value;
                Object[] o = new Object[a.length];
                for (int i = 0; i < a.length; ++i) {
                    o[i] = a[i];
                }
                this.writeJsonValue(o);
            }
        } else {
            this.writer.append('\"');
            ParseHelper.escape2(value.toString(), this.writer);
            this.writer.append('\"');
        }
    }

    private void writeJsonValue(@NotNull Object[] value) throws IOException {
        this.writer.append('[').append('\n');
        this.offset.add();
        boolean first = true;
        for (Object o : value) {
            if (!first) {
                this.writer.append(',').append('\n');
            } else {
                first = false;
            }
            this.writer.append(this.offset.toString());
            this.writeJsonValue(o);
        }
        this.writer.append('\n');
        this.offset.remove();
        this.writer.append(this.offset.toString()).append(']');
    }
}

