/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.parser;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ParseHelper {
    public static final String[] ESCAPE_PRE_ZEROS = new String[]{"", "0", "00", "000", "0000"};

    public static void escape2(@NotNull String s, @NotNull StringBuilder str) {
        try {
            ParseHelper.escape2(s, (Appendable)str);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void escape2(@NotNull String s, @NotNull Appendable str) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '/') {
                str.append("\\/");
                continue;
            }
            if (c == '\"') {
                str.append("\\\"");
                continue;
            }
            if (c == '\\') {
                str.append("\\\\");
                continue;
            }
            if (c == '\n') {
                str.append("\\n");
                continue;
            }
            if (c == '\f') {
                str.append("\\f");
                continue;
            }
            if (c == '\r') {
                str.append("\\r");
                continue;
            }
            if (c == '\t') {
                str.append("\\t");
                continue;
            }
            if (c == '\b') {
                str.append("\\b");
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c <= '\u009f') {
                String ss = Integer.toHexString(c);
                str.append("\\u");
                str.append(ESCAPE_PRE_ZEROS[Math.max(0, 4 - ss.length())]);
                str.append(ss.toUpperCase());
                continue;
            }
            str.append(c);
        }
    }
}

