/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.data.so;

import de.linusdev.data.entry.Entry;
import de.linusdev.data.implemantations.SODataListImpl;
import de.linusdev.data.implemantations.SODataMapImpl;
import de.linusdev.data.implemantations.SODataWrapperImpl;
import de.linusdev.data.so.SAOData;
import de.linusdev.data.so.SODataWrapper;
import de.linusdev.data.so.SODatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface SOData
extends SAOData<Object>,
SODatable {
    @Contract(pure=true)
    @NotNull
    public static SOData newOrderedDataWithKnownSize(int initialCapacity) {
        return new SODataListImpl((List<Entry<String, Object>>)new ArrayList<Entry<String, Object>>(initialCapacity));
    }

    @Contract(pure=true)
    @NotNull
    public static SOData newOrderedDataWithUnknownSize() {
        return new SODataListImpl((List<Entry<String, Object>>)new LinkedList<Entry<String, Object>>());
    }

    @NotNull
    public static SOData newHashMapData(int initialCapacity) {
        return new SODataMapImpl((Map<String, Object>)new HashMap<String, Object>(initialCapacity));
    }

    @NotNull
    public static SODataWrapper wrap(Object object) {
        return new SODataWrapperImpl(object);
    }

    @Override
    default public SOData getData() {
        return this;
    }
}

