/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async;

import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.Task;
import de.linusdev.lutils.async.consumer.ResultAndErrorConsumer;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.consumer.SingleResultConsumer;
import de.linusdev.lutils.async.error.AsyncError;
import de.linusdev.lutils.async.exception.CancellationException;
import de.linusdev.lutils.async.exception.ErrorException;
import de.linusdev.lutils.async.manager.HasAsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Future<R, S>
extends HasAsyncManager {
    @NotNull
    public Future<R, S> cancel();

    public boolean isCanceled();

    public boolean hasStarted();

    public boolean isDone();

    @NotNull
    public Future<R, S> beforeExecution(@NotNull Consumer<Future<R, S>> var1);

    @NotNull
    public Future<R, S> then(@NotNull ResultConsumer<R, S> var1);

    @NotNull
    default public Future<R, S> then(@NotNull ResultAndErrorConsumer<R, S> consumer) {
        this.then((ResultConsumer<R, S>)consumer);
        return this;
    }

    @NotNull
    default public Future<R, S> then(final @NotNull SingleResultConsumer<R, S> consumer) {
        this.then(new ResultConsumer<R, S>(){

            @Override
            public void consume(@NotNull R result, @NotNull S secondary) {
                consumer.consume(result);
            }

            @Override
            public void onError(@NotNull AsyncError error, @Nullable Task<R, S> task, @NotNull S secondary) {
                consumer.onError(error, task, secondary);
            }
        });
        return this;
    }

    @Blocking
    @NotNull
    public ComputationResult<R, S> get() throws InterruptedException, CancellationException;

    @Blocking
    @NotNull
    default public R getResult() throws InterruptedException, ErrorException {
        ComputationResult<R, S> result = this.get();
        if (result.hasError()) {
            throw new ErrorException(result.getError());
        }
        return result.getResult();
    }
}

