/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.async.completeable;

import de.linusdev.lutils.async.AbstractFuture;
import de.linusdev.lutils.async.ComputationResult;
import de.linusdev.lutils.async.Future;
import de.linusdev.lutils.async.completeable.CompletableTask;
import de.linusdev.lutils.async.consumer.ResultConsumer;
import de.linusdev.lutils.async.error.AsyncError;
import de.linusdev.lutils.async.manager.AsyncManager;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletableFuture<R, S, T extends CompletableTask<R, S>>
extends AbstractFuture<R, S, T> {
    private final boolean supportsBeforeExecutionListener;

    protected CompletableFuture(@NotNull AsyncManager asyncManager, boolean supportsBeforeExecutionListener) {
        this(null, asyncManager, supportsBeforeExecutionListener);
    }

    @NotNull
    public static <R, S> CompletableFuture<R, S, CompletableTask<R, S>> create(@NotNull AsyncManager asyncManager, boolean supportsBeforeExecutionListener) {
        return new CompletableFuture(asyncManager, supportsBeforeExecutionListener);
    }

    public CompletableFuture(@Nullable T task, @NotNull AsyncManager asyncManager, boolean supportsBeforeExecutionListener) {
        super(task, asyncManager);
        this.supportsBeforeExecutionListener = supportsBeforeExecutionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(@Nullable R result, @NotNull S secondary, @Nullable AsyncError error) {
        if (result == null && error == null) {
            throw new IllegalArgumentException("result or error must be not null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.result = new ComputationResult<R, S>(result, secondary, error);
            this.done = true;
            if (this.isCanceled()) {
                return;
            }
            this.lock.notifyAll();
        }
        try {
            ResultConsumer then = this.then;
            if (then != null) {
                if (result != null) {
                    then.consume(result, secondary);
                } else {
                    then.onError(error, this.task, secondary);
                }
            }
        }
        catch (Throwable t) {
            this.getAsyncManager().onExceptionInListener(this, this.task, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startIfNotCanceled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCanceled() || this.hasStarted() || this.isDone()) {
                return true;
            }
        }
        try {
            Consumer before = this.before;
            if (before != null) {
                before.accept(this);
            }
        }
        catch (Throwable t) {
            this.getAsyncManager().onExceptionInListener(this, this.task, t);
        }
        object = this.lock;
        synchronized (object) {
            if (this.isCanceled() || this.hasStarted() || this.isDone()) {
                return true;
            }
            this.started = true;
            return false;
        }
    }

    @Override
    @NotNull
    public Future<R, S> beforeExecution(@NotNull Consumer<Future<R, S>> consumer) {
        if (!this.supportsBeforeExecutionListener) {
            throw new UnsupportedOperationException("Completable future does not support before execution listener.");
        }
        return super.beforeExecution(consumer);
    }

    public boolean supportsBeforeExecutionListener() {
        return this.supportsBeforeExecutionListener;
    }
}

