/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen;

import de.linusdev.lutils.codegen.c.CPPFileGenerator;
import de.linusdev.lutils.codegen.java.JavaFileGenerator;
import de.linusdev.lutils.codegen.java.JavaPackage;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceGenerator {
    @NotNull
    private final JavaSourceGeneratorHelper sg = JavaSourceGeneratorHelper.getDefault();
    @NotNull
    private final Path sourceFolder;
    @NotNull
    private JavaPackage javaBasePackage = new JavaPackage(new String[0]);
    @NotNull
    private final List<JavaFileGenerator> javaFiles = new ArrayList<JavaFileGenerator>();
    @NotNull
    private final List<CPPFileGenerator> cppFiles = new ArrayList<CPPFileGenerator>();

    public SourceGenerator(@NotNull Path sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setJavaBasePackage(@NotNull String javaBasePackage) {
        this.javaBasePackage = new JavaPackage(javaBasePackage);
    }

    @NotNull
    public JavaPackage getJavaBasePackage() {
        return this.javaBasePackage;
    }

    @NotNull
    public CPPFileGenerator addCFile() {
        CPPFileGenerator file = new CPPFileGenerator();
        this.cppFiles.add(file);
        return file;
    }

    @NotNull
    public JavaFileGenerator addJavaFile(String ... javaPackage) {
        JavaFileGenerator file = new JavaFileGenerator(this.javaBasePackage.extend(javaPackage), this.sg);
        this.javaFiles.add(file);
        return file;
    }

    @NotNull
    public JavaSourceGeneratorHelper getSg() {
        return this.sg;
    }

    @Nullable
    public JavaFileGenerator getJavaFile(@NotNull String javaPackage, @NotNull String name) {
        for (JavaFileGenerator javaFile : this.javaFiles) {
            if (!javaFile.getName().equals(name) || !javaFile.getPackage().getPackageString().equals(javaPackage)) continue;
            return javaFile;
        }
        return null;
    }

    @NotNull
    public JavaFileGenerator addJavaFile(@Nullable String javaPackage) {
        if (javaPackage == null) {
            return this.addJavaFile(new String[0]);
        }
        JavaFileGenerator file = new JavaFileGenerator(this.javaBasePackage.extend(javaPackage), this.sg);
        this.javaFiles.add(file);
        return file;
    }

    @NotNull
    public Path getJavaSourcePath() {
        return this.sourceFolder.resolve(this.sg.javaSourcePath());
    }

    @NotNull
    public Path getCppSourcePath() {
        return this.sourceFolder.resolve("src/main/cpp");
    }

    public void write() throws IOException {
        BufferedWriter writer;
        if (!this.javaFiles.isEmpty()) {
            Path javaSourcePath = this.getJavaSourcePath();
            Files.createDirectories(javaSourcePath, new FileAttribute[0]);
            for (JavaFileGenerator javaFileGenerator : this.javaFiles) {
                Path javaFilePackagePath = javaSourcePath.resolve(javaFileGenerator.getPackage().getPath());
                Path javaFilePath = javaFilePackagePath.resolve(javaFileGenerator.getName() + ".java");
                Files.createDirectories(javaFilePackagePath, new FileAttribute[0]);
                writer = Files.newBufferedWriter(javaFilePath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    javaFileGenerator.write(writer);
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        if (!this.cppFiles.isEmpty()) {
            Path cppSourcePath = this.getCppSourcePath();
            Files.createDirectories(cppSourcePath, new FileAttribute[0]);
            for (CPPFileGenerator cPPFileGenerator : this.cppFiles) {
                Path cppFilePackagePath = cppSourcePath.resolve(cPPFileGenerator.getPath());
                Path cppFilePath = cppFilePackagePath.resolve(cPPFileGenerator.getName() + "." + cPPFileGenerator.getType().getFileEnding());
                Files.createDirectories(cppFilePackagePath, new FileAttribute[0]);
                writer = Files.newBufferedWriter(cppFilePath, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    cPPFileGenerator.write(writer);
                }
                finally {
                    if (writer != null) {
                        ((Writer)writer).close();
                    }
                }
            }
        }
    }

    public static class Test {
    }
}

