/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import de.linusdev.lutils.html.HtmlUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaDocGenerator
implements PartGenerator<JavaSourceGeneratorHelper> {
    private final StringBuilder text = new StringBuilder();

    @NotNull
    public static String escape(@NotNull String text) {
        return HtmlUtils.escape(text, false);
    }

    public void addText(@NotNull String text) {
        this.addText(text, false);
    }

    public void addText(@NotNull String text, boolean escape) {
        if (escape) {
            text = JavaDocGenerator.escape(text);
        }
        this.text.append(text);
    }

    public void addTextNl(@NotNull String text) {
        this.addTextNl(text, false);
    }

    public void addTextNl(@NotNull String text, boolean escape) {
        if (escape) {
            text = JavaDocGenerator.escape(text);
        }
        this.text.append(text).append("\n");
    }

    public void addAtText(@NotNull String at, @NotNull String text) {
        this.addAtText(at, text, false);
    }

    public void addAtText(@NotNull String at, @NotNull String text, boolean escape) {
        if (escape) {
            text = JavaDocGenerator.escape(text);
        }
        this.text.append("\n").append("@").append(at).append(" ").append(text).append("\n");
    }

    @Override
    public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> state) throws IOException {
        String[] lines;
        writer.append(state.getSg().javaLineBreak());
        writer.append(state.getIndent()).append("/**").append(state.getSg().javaLineBreak());
        String fin = this.text.toString();
        for (String line : lines = fin.split("\n")) {
            writer.append(state.getIndent()).append(" * ").append(line).append(state.getSg().javaLineBreak());
        }
        writer.append(state.getIndent()).append(" */");
        writer.append(state.getSg().javaLineBreak());
    }
}

