/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.java.JavaAnnotation;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaClassType;
import de.linusdev.lutils.codegen.java.JavaExpression;
import de.linusdev.lutils.codegen.java.JavaImport;
import de.linusdev.lutils.codegen.java.JavaLocalVariable;
import de.linusdev.lutils.codegen.java.JavaMethodGenerator;
import de.linusdev.lutils.codegen.java.JavaPackage;
import de.linusdev.lutils.codegen.java.JavaVariable;
import de.linusdev.lutils.codegen.java.JavaVisibility;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JavaSourceGeneratorHelper {
    public static final String SEMICOLON = ";";
    public static final String LINE_BREAK = "\n";
    public static final String INDENT = "    ";
    public static final String CURLY_BRACKET_OPEN = "{";
    public static final String CURLY_BRACKET_CLOSE = "}";
    public static final String ASTERISK = "*";
    public static final String AT = "@";
    public static final String BRACKET_OPEN = "(";
    public static final String BRACKET_CLOSE = ")";
    public static final String EQUALS = "=";
    public static final String PACKAGE = "package";
    public static final String IMPORT = "import";
    public static final String EXTENDS = "extends";
    public static final String IMPLEMENTS = "implements";
    public static final String STATIC = "static";
    public static final String FINAL = "final";
    public static final String NULL = "null";
    public static final String SUPER = "super";
    public static final String ENUM = "enum";
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String RECORD = "record";
    public static final String PUBLIC = "public";
    public static final String PRIVATE = "private";
    public static final String PROTECTED = "protected";

    @NotNull
    public static JavaSourceGeneratorHelper getDefault() {
        return new JavaSourceGeneratorHelper(){};
    }

    default public String javaNull() {
        return NULL;
    }

    default public String javaExpressionEnd() {
        return SEMICOLON;
    }

    @NotNull
    default public Path javaSourcePath() {
        return Paths.get("src", "main", "java");
    }

    @NotNull
    default public Path javaResourcesPath() {
        return Paths.get("src", "main", "resources");
    }

    default public String javaLineBreak() {
        return LINE_BREAK;
    }

    default public String javaIndent() {
        return INDENT;
    }

    default public String javaPackageDeclarationStart() {
        return "package ";
    }

    default public String javaEnumName() {
        return ENUM;
    }

    default public String javaClassName() {
        return CLASS;
    }

    default public String javaRecordName() {
        return RECORD;
    }

    default public String javaInterfaceName() {
        return INTERFACE;
    }

    default public String javaPublic() {
        return PUBLIC;
    }

    default public String javaProtected() {
        return PROTECTED;
    }

    default public String javaPrivate() {
        return PRIVATE;
    }

    default public String javaPackagePrivate() {
        return "";
    }

    default public String javaImportStart() {
        return "import ";
    }

    default public String javaBlockStart() {
        return CURLY_BRACKET_OPEN;
    }

    default public String javaBlockEnd() {
        return CURLY_BRACKET_CLOSE;
    }

    default public String javaClassEndExpression() {
        return CURLY_BRACKET_CLOSE;
    }

    default public String javaExtendsKeyword() {
        return EXTENDS;
    }

    default public String javaImplementsKeyword() {
        return IMPLEMENTS;
    }

    default public String javaStaticKeyword() {
        return STATIC;
    }

    default public String javaNativeKeyword() {
        return "native";
    }

    default public String javaFinalKeyword() {
        return FINAL;
    }

    default public String javaAnnotationStart() {
        return AT;
    }

    default public String javaAssign() {
        return EQUALS;
    }

    default public String javaSuper() {
        return SUPER;
    }

    default public String javaMethodCall(@NotNull String methodName, JavaExpression ... parameters) {
        StringBuilder str = new StringBuilder(methodName + BRACKET_OPEN);
        boolean first = true;
        for (JavaExpression parameter : parameters) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(parameter.getExprString(this));
        }
        return str.toString() + BRACKET_CLOSE;
    }

    default public String javaStaticMethodCall(@NotNull JavaClass parent, @NotNull String methodName, JavaExpression ... parameters) {
        StringBuilder str = new StringBuilder(parent.getName() + "." + methodName + BRACKET_OPEN);
        boolean first = true;
        for (JavaExpression parameter : parameters) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(parameter.getExprString(this));
        }
        return str.toString() + BRACKET_CLOSE;
    }

    default public String javaVariableType(@NotNull JavaClass javaClass) {
        return javaClass.getTypeName();
    }

    default public String javaMethodOpenExpression(@NotNull JavaMethodGenerator method) throws IOException {
        StringBuilder str = new StringBuilder(method.getVisibility().getName(this));
        if (!str.toString().isBlank()) {
            str.append(" ");
        }
        if (method.isStatic()) {
            str.append(this.javaStaticKeyword()).append(" ");
        }
        if (method.isNative()) {
            str.append(this.javaNativeKeyword()).append(" ");
        }
        if (method.isFinal()) {
            str.append(this.javaFinalKeyword()).append(" ");
        }
        if (method.isConstructor) {
            str.append(this.javaVariableType(method.getReturnType())).append(BRACKET_OPEN);
        } else {
            str.append(this.javaVariableType(method.getReturnType())).append(" ");
            str.append(method.getName()).append(BRACKET_OPEN);
        }
        boolean first = true;
        for (JavaLocalVariable param : method.getParameters()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            param.write((Appendable)str, new GeneratorState<JavaSourceGeneratorHelper>("", this));
        }
        str.append(") ");
        if (!method.isNoBody()) {
            str.append(this.javaBlockStart());
        }
        return "" + str;
    }

    default public String javaMethodCloseExpression(@NotNull JavaMethodGenerator method) {
        if (method.isNoBody()) {
            return SEMICOLON;
        }
        return this.javaBlockEnd();
    }

    default public String javaVariableExpression(@NotNull JavaVariable variable) {
        Object str = variable.getVisibility().getName(this);
        if (!((String)str).isBlank()) {
            str = (String)str + " ";
        }
        if (variable.isStatic()) {
            str = (String)str + this.javaStaticKeyword() + " ";
        }
        if (variable.isFinal()) {
            str = (String)str + this.javaFinalKeyword() + " ";
        }
        str = (String)str + this.javaVariableType(variable.getType()) + " ";
        str = (String)str + variable.getName();
        if (variable.getDefaultValue() != null) {
            str = (String)str + " " + this.javaAssign() + " " + variable.getDefaultValue().getExprString(this);
        }
        return str;
    }

    default public String javaDeclareLocalVariableExpression(@NotNull JavaLocalVariable variable) {
        Object str = "";
        if (variable.isFinal()) {
            str = (String)str + this.javaFinalKeyword() + " ";
        }
        str = (String)str + this.javaVariableType(variable.getType()) + " ";
        str = (String)str + variable.getName();
        if (variable.getDefaultValue() != null) {
            str = (String)str + " " + this.javaAssign() + " " + variable.getDefaultValue().getExprString(this);
        }
        return str;
    }

    default public String javaPackageExpression(@NotNull JavaPackage jPackage) {
        return this.javaPackageDeclarationStart() + jPackage.getPackageString() + this.javaExpressionEnd();
    }

    default public String javaAnnotation(@NotNull JavaAnnotation annotation) {
        StringBuilder str = new StringBuilder(this.javaAnnotationStart() + annotation.getType().getName());
        if (annotation.getValues() != null) {
            str.append(BRACKET_OPEN);
            boolean first = true;
            for (Map.Entry<JavaVariable, JavaExpression> entry : annotation.getValues().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append(entry.getKey().getName()).append(" ").append(this.javaAssign()).append(" ").append(entry.getValue().getExprString(this));
            }
            str.append(BRACKET_CLOSE);
        }
        return str.toString();
    }

    default public String javaClassOpenExpression(@NotNull JavaVisibility visibility, boolean isStatic, @NotNull JavaClassType type, @NotNull String name, @Nullable JavaClass extendClass, JavaClass ... implementsClasses) {
        StringBuilder str = new StringBuilder(visibility.getName(this));
        if (!str.toString().isBlank()) {
            str.append(" ");
        }
        if (isStatic) {
            str.append(this.javaStaticKeyword()).append(" ");
        }
        str.append(type.getName(this)).append(" ").append(name);
        if (extendClass != null) {
            str.append(" ").append(this.javaExtendsKeyword()).append(" ").append(extendClass.getTypeName());
        }
        if (implementsClasses.length != 0) {
            str.append(" ").append(this.javaImplementsKeyword()).append(" ");
            str.append(implementsClasses[0].getTypeName());
            for (int i = 1; i < implementsClasses.length; ++i) {
                str.append(", ").append(implementsClasses[i].getTypeName());
            }
        }
        return str + " " + this.javaBlockStart();
    }

    default public String javaImportExpression(@NotNull JavaImport jImport) {
        return this.javaImportStart() + jImport.getPackage().getPackageString() + "." + jImport.getClassName() + (String)(jImport.getVariable() == null ? "" : "." + jImport.getVariable()) + this.javaExpressionEnd();
    }

    default public String javaNumberExpression(@NotNull Number number) {
        if (number instanceof Long) {
            return number + "L";
        }
        return number.toString();
    }

    default public String javaBooleanExpression(boolean bool) {
        return Boolean.toString(bool);
    }
}

