/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.codegen.java;

import de.linusdev.lutils.codegen.GeneratorState;
import de.linusdev.lutils.codegen.PartGenerator;
import de.linusdev.lutils.codegen.java.JavaAnnotateable;
import de.linusdev.lutils.codegen.java.JavaAnnotation;
import de.linusdev.lutils.codegen.java.JavaAssignable;
import de.linusdev.lutils.codegen.java.JavaClass;
import de.linusdev.lutils.codegen.java.JavaDocGenerator;
import de.linusdev.lutils.codegen.java.JavaDocable;
import de.linusdev.lutils.codegen.java.JavaExpression;
import de.linusdev.lutils.codegen.java.JavaFileState;
import de.linusdev.lutils.codegen.java.JavaSourceGeneratorHelper;
import de.linusdev.lutils.codegen.java.JavaVisibility;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVariable
implements JavaAssignable,
JavaAnnotateable,
PartGenerator<JavaSourceGeneratorHelper>,
JavaDocable {
    @Nullable
    protected final JavaFileState ft;
    @NotNull
    protected final JavaClass parentClass;
    @NotNull
    protected final JavaClass type;
    @NotNull
    protected final String name;
    protected boolean isStatic = false;
    protected boolean isFinal = false;
    @NotNull
    protected JavaVisibility visibility = JavaVisibility.PACKAGE_PRIVATE;
    @Nullable
    protected JavaExpression defaultValue;
    @Nullable
    protected JavaDocGenerator javaDoc = null;
    @NotNull
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();

    @NotNull
    public static <T> JavaVariable of(@NotNull Class<?> clazz, @NotNull String varName) {
        try {
            if (clazz.isAnnotation()) {
                Method m = clazz.getMethod(varName, new Class[0]);
                return new JavaVariable(null, JavaClass.ofClass(clazz), JavaClass.ofClass(m.getReturnType()), varName);
            }
            Field f = clazz.getField(varName);
            JavaVariable variable = new JavaVariable(null, JavaClass.ofClass(clazz), JavaClass.ofClass(f.getType()), varName);
            variable.setFinal(Modifier.isFinal(f.getModifiers()));
            variable.setStatic(Modifier.isStatic(f.getModifiers()));
            return variable;
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public JavaVariable(@Nullable JavaFileState ft, @NotNull JavaClass parentClass, @NotNull JavaClass type, @NotNull String name) {
        this.ft = ft;
        this.parentClass = parentClass;
        this.type = type;
        this.name = name;
    }

    public void setVisibility(@NotNull JavaVisibility visibility) {
        this.visibility = visibility;
    }

    @NotNull
    public JavaVisibility getVisibility() {
        return this.visibility;
    }

    public void setStatic(boolean jStatic) {
        this.isStatic = jStatic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setFinal(boolean jFinal) {
        this.isFinal = jFinal;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public JavaClass getType() {
        return this.type;
    }

    @Nullable
    public JavaExpression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable JavaExpression defaultValue) {
        this.defaultValue = defaultValue;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVariable)) {
            return false;
        }
        JavaVariable variable = (JavaVariable)o;
        return JavaClass.equals(this.parentClass, variable.parentClass) && this.name.equals(variable.name);
    }

    public int hashCode() {
        int result = JavaClass.hashcode(this.parentClass);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    @NotNull
    public JavaAnnotation addAnnotation(@NotNull JavaClass annotationClass) {
        if (this.ft == null) {
            throw new IllegalStateException("Cannot add an annotation to a non generator variable.");
        }
        JavaAnnotation annotation = new JavaAnnotation(this.ft, annotationClass);
        this.annotations.add(annotation);
        return annotation;
    }

    @Override
    public void write(@NotNull Appendable writer, @NotNull GeneratorState<JavaSourceGeneratorHelper> state) throws IOException {
        if (this.javaDoc != null) {
            this.javaDoc.write(writer, state);
        }
        for (JavaAnnotation annotation : this.annotations) {
            writer.append(state.getIndent()).append(state.getSg().javaAnnotation(annotation)).append(state.getSg().javaLineBreak());
        }
        writer.append(state.getIndent()).append(state.getSg().javaVariableExpression(this));
    }

    @Override
    @NotNull
    public JavaDocGenerator setJavaDoc() {
        if (this.javaDoc == null) {
            this.javaDoc = new JavaDocGenerator();
        }
        return this.javaDoc;
    }
}

