/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.color;

import de.linusdev.lutils.color.HSVAColor;
import de.linusdev.lutils.color.RGBAColor;
import de.linusdev.lutils.color.impl.HSVAColorImpl;
import de.linusdev.lutils.color.impl.RGBAColorDoubleImpl;
import de.linusdev.lutils.color.impl.RGBAColorIntImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface Color {
    public static final RGBAColor BLACK = Color.ofRGB(0, 0, 0);
    public static final RGBAColor RED = Color.ofRGB(255, 0, 0);
    public static final RGBAColor GREEN = Color.ofRGB(0, 255, 0);
    public static final RGBAColor BLUE = Color.ofRGB(0, 0, 255);
    public static final RGBAColor WHITE = Color.ofRGB(255, 255, 255);
    public static final RGBAColor CYAN = Color.ofRGB(17, 168, 205);
    public static final RGBAColor ORANGE = Color.ofRGB(250, 138, 10);
    public static final RGBAColor DARK_GRAY = Color.ofRGB(0x808080);
    public static final RGBAColor LIGHT_GRAY = Color.ofRGB(0xD3D3D3);
    public static final RGBAColor GRAY = Color.ofRGB(0xA9A9A9);

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b) {
        return new RGBAColorIntImpl(r, g, b, 255);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(@Range(from=0L, to=255L) int r, @Range(from=0L, to=255L) int g, @Range(from=0L, to=255L) int b, @Range(from=0L, to=255L) int a) {
        return new RGBAColorIntImpl(r, g, b, a);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(int hex) {
        return new RGBAColorIntImpl((hex & 0xFF000000) >>> 24, (hex & 0xFF0000) >>> 16, (hex & 0xFF00) >>> 8, hex & 0xFF);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(int hex) {
        return new RGBAColorIntImpl((hex & 0xFF0000) >>> 16, (hex & 0xFF00) >>> 8, hex & 0xFF, 255);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGB(@Range(from=0L, to=1L) double r, @Range(from=0L, to=1L) double g, @Range(from=0L, to=1L) double b) {
        return new RGBAColorDoubleImpl(r, g, b, 1.0);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static RGBAColor ofRGBA(@Range(from=0L, to=1L) double r, @Range(from=0L, to=1L) double g, @Range(from=0L, to=1L) double b, @Range(from=0L, to=1L) double a) {
        return new RGBAColorDoubleImpl(r, g, b, a);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static HSVAColor ofHSV(@Range(from=0L, to=360L) double h, @Range(from=0L, to=100L) double s, @Range(from=0L, to=100L) double v) {
        return new HSVAColorImpl(h, s, v, 1.0);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static HSVAColor ofHSVA(@Range(from=0L, to=360L) double h, @Range(from=0L, to=100L) double s, @Range(from=0L, to=100L) double v, @Range(from=0L, to=1L) double a) {
        return new HSVAColorImpl(h, s, v, a);
    }

    @NotNull
    public RGBAColor toRGBAColor();

    @NotNull
    public HSVAColor toHSVAColor();
}

