/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html;

import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HasHtmlContent {
    @NotNull
    public @NotNull List<@NotNull HtmlObject> content();

    default public void iterateContentRecursive(@NotNull @NotNull Consumer<@NotNull HtmlObject> consumer) {
        for (HtmlObject object : this.content()) {
            consumer.accept(object);
            if (object.type() != HtmlObjectType.ELEMENT) continue;
            object.asHtmlElement().iterateContentRecursive(consumer);
        }
    }

    @NotNull
    default public @NotNull Iterator<@NotNull HtmlElement> children() {
        return new Iterator<HtmlElement>(){
            final Iterator<@NotNull HtmlObject> it;
            @Nullable
            HtmlElement next;
            {
                this.it = HasHtmlContent.this.content().iterator();
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null && !this.it.hasNext()) {
                    return false;
                }
                if (this.next != null) {
                    return true;
                }
                this.getNext();
                return this.hasNext();
            }

            @Override
            public HtmlElement next() {
                if (this.next == null) {
                    this.getNext();
                    return this.next();
                }
                HtmlElement buf = this.next;
                this.next = null;
                return buf;
            }

            private void getNext() {
                if (this.next != null) {
                    return;
                }
                HtmlObject obj = this.it.next();
                while (obj.type() != HtmlObjectType.ELEMENT && this.it.hasNext()) {
                    obj = this.it.next();
                }
                if (obj.type() != HtmlObjectType.ELEMENT) {
                    return;
                }
                this.next = obj.asHtmlElement();
            }
        };
    }
}

