/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.impl;

import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectParser;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.parser.HtmlWritingState;
import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class HtmlComment
implements HtmlObject {
    @NotNull
    public static final HtmlObjectParser<HtmlComment> PARSER = (state, reader) -> {
        String text;
        char c = reader.read();
        if (c != '<') {
            throw state.fail(c);
        }
        c = reader.read();
        if (c != '!') {
            throw state.fail(c);
        }
        c = reader.read();
        if (c != '-') {
            throw state.fail(c);
        }
        c = reader.read();
        if (c != '-') {
            throw state.fail(c);
        }
        StringBuilder comment = new StringBuilder();
        while (!(text = reader.readUntil('>')).endsWith("--")) {
            comment.append(text);
            comment.append('>');
        }
        comment.append(text, 0, text.length() - 2);
        return new HtmlComment(comment.toString());
    };
    @NotNull
    private final String text;

    public HtmlComment(@NotNull String text) {
        this.text = text;
    }

    @Override
    @NotNull
    public HtmlObjectType type() {
        return HtmlObjectType.TEXT;
    }

    @Override
    @NotNull
    public HtmlComment copy() {
        return this;
    }

    @Override
    public void write(@NotNull HtmlWritingState state, @NotNull Writer writer) throws IOException {
        writer.append("<!--").append(this.text).append("-->");
    }
}

