/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.html.lhtml;

import de.linusdev.lutils.html.HtmlAttribute;
import de.linusdev.lutils.html.HtmlAttributeMap;
import de.linusdev.lutils.html.HtmlElement;
import de.linusdev.lutils.html.HtmlElementType;
import de.linusdev.lutils.html.HtmlObject;
import de.linusdev.lutils.html.HtmlObjectType;
import de.linusdev.lutils.html.impl.StandardHtmlAttributeTypes;
import de.linusdev.lutils.html.impl.element.StandardHtmlElement;
import de.linusdev.lutils.html.impl.element.StandardHtmlElementTypes;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LhtmlHead
extends StandardHtmlElement {
    @NotNull
    public static final StandardHtmlElement.CustomType<Builder> TYPE = StandardHtmlElement.Type.newCustom(Builder::new, "head");
    @NotNull
    protected final HashMap<String, HtmlElement> links;

    protected LhtmlHead(@NotNull StandardHtmlElement.AbstractType<?> tag, @NotNull @NotNull List<@NotNull HtmlObject> content, @NotNull HtmlAttributeMap attributes, @NotNull HashMap<String, HtmlElement> links) {
        super(tag, content, attributes);
        this.links = links;
    }

    public void addLink(@NotNull HtmlElement element) {
        if (!HtmlElementType.equals(StandardHtmlElementTypes.LINK, element.tag())) {
            throw new IllegalArgumentException("Given element is not a link, but it is '" + element.tag().name() + "'.");
        }
        HtmlAttribute hrefAttr = element.attributes().get(StandardHtmlAttributeTypes.HREF);
        if (hrefAttr == null) {
            throw new IllegalArgumentException("Given link has no href attribute.");
        }
        if (this.links.get(hrefAttr.value()) != null) {
            return;
        }
        this.addContent(element);
        this.links.put(hrefAttr.value(), element);
    }

    public void addLinks(@NotNull LhtmlHead other) {
        for (HtmlElement link : other.links.values()) {
            this.addLink(link);
        }
    }

    public static class Builder
    extends StandardHtmlElement.AbstractBuilder<Builder> {
        @NotNull
        protected final HashMap<String, HtmlElement> links = new HashMap();

        public Builder(@NotNull StandardHtmlElement.CustomType<Builder> tag) {
            super(tag);
        }

        @Override
        @Nullable
        protected HtmlObject onContentAdd(@NotNull HtmlObject object) {
            if (object.type() != HtmlObjectType.ELEMENT) {
                return super.onContentAdd(object);
            }
            HtmlElement element = object.asHtmlElement();
            if (HtmlElementType.equals(StandardHtmlElementTypes.LINK, element.tag())) {
                HtmlAttribute hrefAttr = element.attributes().get(StandardHtmlAttributeTypes.HREF);
                if (hrefAttr == null) {
                    return super.onContentAdd(object);
                }
                this.links.put(hrefAttr.value(), element);
            }
            return super.onContentAdd(object);
        }

        @Override
        @NotNull
        public LhtmlHead build() {
            return new LhtmlHead(this.tag, this.content, this.attributes, this.links);
        }
    }
}

