/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.png.reader;

import de.linusdev.lutils.image.Image;
import de.linusdev.lutils.image.java.JavaBackedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public class PNGReader {
    @NotNull
    public static Image read(@NotNull InputStream in) throws IOException {
        return new JavaBackedImage(ImageIO.read(in));
    }

    @NotNull
    public static Image readFromResource(@NotNull String name) throws IOException {
        try (InputStream in = PNGReader.class.getClassLoader().getResourceAsStream(name);){
            if (in == null) {
                throw new IllegalArgumentException("Cannot find resource '" + name + "'.");
            }
            Image image = PNGReader.read(in);
            return image;
        }
    }
}

