/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.image.wip_webp.reader;

import org.jetbrains.annotations.NotNull;

public class BitReader {
    private static final byte @NotNull [] OR_LEFT = new byte[]{0, -128, -64, -32, -16, -8, -4, -2};
    private static final byte @NotNull [] OR_RIGHT = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1, 0};
    private final byte @NotNull [] data;
    private int bitPos = 0;
    private int bytePos = 0;

    public BitReader(byte @NotNull [] data) {
        this.data = data;
    }

    public byte readByte() {
        return this.readBitsToByte(8);
    }

    public byte readBitsToByte(int bitCount) {
        assert (bitCount <= 8 && bitCount > 0);
        byte ub = 0;
        int remaining = this._bitsRemaining();
        if (remaining > 0) {
            ub = (byte)(ub | this._readRemainingBits(bitCount) & 0xFF);
            if ((bitCount -= remaining) <= 0) {
                return ub;
            }
        }
        if (bitCount == 8) {
            return this._readByte();
        }
        return (byte)(ub << bitCount | this._readBits(bitCount));
    }

    public int readBitsToInt(int bitCount) {
        assert (bitCount <= 32 && bitCount > 0);
        int ui = 0;
        int remaining = this._bitsRemaining();
        if (remaining > 0) {
            ui |= this._readRemainingBits(bitCount) & 0xFF;
            if ((bitCount -= remaining) <= 0) {
                return ui;
            }
        }
        int byteCount = bitCount / 8;
        bitCount -= byteCount * 8;
        if (byteCount >= 1) {
            ui = ui << 8 | this._readByte() & 0xFF;
        }
        if (byteCount >= 2) {
            ui = ui << 8 | this._readByte() & 0xFF;
        }
        if (byteCount >= 3) {
            ui = ui << 8 | this._readByte() & 0xFF;
        }
        if (byteCount == 4) {
            ui = ui << 8 | this._readByte() & 0xFF;
        }
        ui = ui << bitCount | this._readBits(bitCount);
        return ui;
    }

    private int _bitsRemaining() {
        assert (this.bitPos <= 7);
        return this.bitPos == 0 ? 0 : 8 - this.bitPos;
    }

    private byte _readRemainingBits(int max) {
        assert (this.bitPos != 0);
        assert (this.bitPos <= 7);
        int tooMuch = Math.max(0, this._bitsRemaining() - max);
        byte ret = (byte)(this.data[this.bytePos] & OR_RIGHT[this.bitPos] & OR_LEFT[OR_LEFT.length - tooMuch]);
        this.bitPos = 8 - tooMuch;
        if (this.bitPos == 0) {
            ++this.bytePos;
        }
        return ret;
    }

    private byte _readBits(int bitCount) {
        assert (bitCount <= 7);
        assert (this.bitPos == 0);
        this.bitPos = (this.bitPos + bitCount) % 8;
        return (byte)((byte)(this.data[this.bytePos] & OR_LEFT[bitCount]) >>> 8 - bitCount);
    }

    private byte _readByte() {
        return this.data[this.bytePos++];
    }
}

