/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceUtils {
    @NotNull
    public static StreamURLConnection getURLConnectionOfResource(@Nullable Class<?> relClazz, @NotNull String path) {
        URL resource;
        if (relClazz == null) {
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("If relClazz is null, an absolute path (starting with '/') must be passed.");
            }
            relClazz = ResourceUtils.class;
        }
        if ((resource = relClazz.getResource(path)) == null) {
            throw new Error("Resource '" + path + "' does not exist. Remember paths starting with \"/\" are absolute. Paths not starting with \"/\" are relative to the package of relClazz.");
        }
        return new StreamURLConnection(path, resource);
    }

    @NotNull
    public static Reader getUtf8Reader(@Nullable Class<?> relClazz, @NotNull String path) throws IOException {
        return new BufferedReader(new InputStreamReader(ResourceUtils.getURLConnectionOfResource(relClazz, path).openInputStream(), StandardCharsets.UTF_8));
    }

    @NotNull
    public static Reader getUtf8Reader(@NotNull String path) throws IOException {
        return ResourceUtils.getUtf8Reader(null, path);
    }

    @NotNull
    public static String readString(@Nullable Class<?> relClazz, @NotNull String path) throws IOException {
        try (InputStream in = ResourceUtils.getURLConnectionOfResource(relClazz, path).openInputStream();){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                string = sb.toString();
            }
            return string;
        }
    }

    public static class StreamURLConnection {
        @NotNull
        private final String path;
        @NotNull
        private final URL resource;
        @Nullable
        private URLConnection currentOpenConnection;

        public StreamURLConnection(@NotNull String path, @NotNull URL resource) {
            this.path = path;
            this.resource = resource;
        }

        @NotNull
        private URLConnection getURLConnection(boolean canCache) {
            if (this.currentOpenConnection != null) {
                if (canCache) {
                    return this.currentOpenConnection;
                }
                URLConnection copy = this.currentOpenConnection;
                this.currentOpenConnection = null;
                return copy;
            }
            try {
                this.currentOpenConnection = this.resource.openConnection();
                return this.getURLConnection(canCache);
            }
            catch (IOException e) {
                throw new Error("Resource '" + this.path + "' cannot be read.", e);
            }
        }

        public long getContentLength() {
            return this.getURLConnection(true).getContentLengthLong();
        }

        @NotNull
        public InputStream openInputStream() throws IOException {
            return this.getURLConnection(false).getInputStream();
        }
    }
}

