/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix.buffer;

import de.linusdev.lutils.math.matrix.Matrix;
import de.linusdev.lutils.math.matrix.MatrixMemoryLayout;
import de.linusdev.lutils.math.matrix.buffer.BBMatrixInfo;
import de.linusdev.lutils.math.vector.buffer.BBVectorInfo;
import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.abi.OverwriteChildABI;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import de.linusdev.lutils.nat.struct.annos.RequirementType;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import de.linusdev.lutils.nat.struct.annos.StructureSettings;
import de.linusdev.lutils.nat.struct.generator.Language;
import de.linusdev.lutils.nat.struct.generator.StaticGenerator;
import de.linusdev.lutils.nat.struct.generator.StructCodeGenerator;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import de.linusdev.lutils.nat.struct.info.StructureInfo;
import de.linusdev.lutils.nat.struct.utils.SSMUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@StructureSettings(requiresCalculateInfoMethod=true, customLayoutOption=RequirementType.OPTIONAL)
public abstract class BBMatrix
extends Structure
implements Matrix {
    @NotNull
    protected final BBMatrixGenerator generator;
    protected ArrayInfo.ArrayPositionFunction positions;
    @NotNull
    protected MatrixMemoryLayout memoryLayout = MatrixMemoryLayout.ROW_MAJOR;

    protected BBMatrix(@NotNull BBMatrixGenerator generator, boolean generateInfo, @Nullable StructValue structValue) {
        this.generator = generator;
        if (generateInfo) {
            this.setInfo(SSMUtils.getInfo(this.getClass(), structValue, null, null, null, null, generator));
        }
    }

    protected int posInBuf(int y, int x) {
        return this.positions.position(this.positionToIndex(y, x));
    }

    protected int posInBuf(int index) {
        return this.positions.position(index);
    }

    @Override
    @Nullable
    protected StructureInfo generateInfo() {
        return SSMUtils.getInfo(this.getClass(), null, null, null, null, null, this.generator);
    }

    @Override
    protected void onSetInfo(@NotNull StructureInfo info) {
        super.onSetInfo(info);
        this.positions = ((BBVectorInfo)info).getPositions();
    }

    @Override
    @NotNull
    public BBMatrixInfo getInfo() {
        return (BBMatrixInfo)super.getInfo();
    }

    @Override
    public int getWidth() {
        return this.getInfo().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getInfo().getHeight();
    }

    @Override
    @NotNull
    public Structure getStructure() {
        return this;
    }

    @Override
    public boolean isArrayBacked() {
        return false;
    }

    @Override
    public boolean isBufferBacked() {
        return true;
    }

    @Override
    @NotNull
    public MatrixMemoryLayout getMemoryLayout() {
        return this.memoryLayout;
    }

    @Override
    public void setMemoryLayout(@NotNull MatrixMemoryLayout memoryLayout) {
        this.memoryLayout = memoryLayout;
    }

    public static class BBMatrixGenerator
    implements StaticGenerator {
        private final int width;
        private final int height;
        @NotNull
        private final NativeType type;

        public BBMatrixGenerator(int width, int height, @NotNull NativeType type) {
            this.width = width;
            this.height = height;
            this.type = type;
        }

        @Override
        @NotNull
        public StructureInfo calculateInfo(@NotNull Class<?> selfClazz, @Nullable StructValue structValue, @NotNull @NotNull StructValue @NotNull [] elementsStructValue, @NotNull ABI abi, @Nullable OverwriteChildABI overwriteChildAbi) {
            return BBMatrixInfo.create(abi, this.width, this.height, this.type);
        }

        @Override
        @Nullable
        public StructCodeGenerator codeGenerator() {
            return new StructCodeGenerator(){

                @Override
                @NotNull
                public String getStructTypeName(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info) {
                    BBMatrixInfo bbInfo = (BBMatrixInfo)info;
                    return language.getNativeTypeName(bbInfo.getType()) + bbInfo.getHeight() + "x" + bbInfo.getWidth();
                }

                @Override
                @NotNull
                public String getStructVarDef(@NotNull Language language, @NotNull Class<?> selfClazz, @NotNull StructureInfo info, @NotNull String varName) {
                    BBMatrixInfo bbInfo = (BBMatrixInfo)info;
                    return language.getNativeTypeName(bbInfo.getType()) + " " + varName + "[" + bbInfo.getHeight() * bbInfo.getWidth() + "]" + language.lineEnding;
                }
            };
        }
    }
}

