/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.matrix.buffer;

import de.linusdev.lutils.math.vector.buffer.BBVectorInfo;
import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.abi.ABI;
import de.linusdev.lutils.nat.struct.info.ArrayInfo;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BBMatrixInfo
extends BBVectorInfo {
    protected final int width;
    protected final int height;

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static BBMatrixInfo create(@NotNull ABI abi, int width, int height, @NotNull NativeType type) {
        ArrayInfo arrayInfo = abi.calculateMatrixLayout(type, width, height);
        return new BBMatrixInfo(arrayInfo.getAlignment(), arrayInfo.getRequiredSize(), arrayInfo.getSizes(), arrayInfo.getLength(), arrayInfo.getStride(), arrayInfo.getPositions(), type, width, height);
    }

    public BBMatrixInfo(int alignment, int size, int @NotNull [] sizes, int length, int stride, @NotNull ArrayInfo.ArrayPositionFunction positions, @NotNull NativeType type, int width, int height) {
        super(alignment, size, sizes, length, stride, positions, type);
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

