/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.special;

import de.linusdev.lutils.math.VMath;
import de.linusdev.lutils.math.matrix.abstracts.floatn.Float4x4;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float3;
import de.linusdev.lutils.math.vector.abstracts.floatn.Float4;
import de.linusdev.lutils.math.vector.array.floatn.ABFloat3;
import org.jetbrains.annotations.NotNull;

public class TransRotMatrix {
    @NotNull
    protected static final Float3 DEFAULT_UP = new ABFloat3(0.0f, 1.0f, 0.0f);
    @NotNull
    protected final Float4x4 backingMatrix;
    @NotNull
    protected final Float4 translationView;
    @NotNull
    protected final Float4 positionView;
    protected float yaw = 0.0f;
    protected float pitch = 0.0f;
    protected float roll = 0.0f;

    public TransRotMatrix(@NotNull Float4x4 backingMatrix) {
        this.backingMatrix = backingMatrix;
        this.backingMatrix.put(3, 3, 1.0f);
        this.translationView = backingMatrix.createFloat4View(0, 3, 1, 3, 2, 3, 3, 3);
        this.positionView = this.translationView.createFactorizedView(-1.0f, -1.0f, -1.0f, 1.0f);
    }

    @NotNull
    public Float4 translation() {
        return this.translationView;
    }

    @NotNull
    public Float4 position() {
        return this.positionView;
    }

    @NotNull
    public Float4x4 backingMatrix() {
        return this.backingMatrix;
    }

    public void setRotation(float yaw, float pitch, float roll) {
        this.yaw = yaw;
        this.pitch = pitch;
        this.roll = roll;
        VMath.rotationMatrix(yaw, pitch, roll, this.backingMatrix);
    }

    public void setRotation(float angle, @NotNull Float3 axis) {
        VMath.rotationMatrix(angle, axis, this.backingMatrix);
    }

    public void addRotation(float yaw, float pitch, float roll) {
        this.yaw += yaw;
        this.pitch += pitch;
        this.roll += roll;
        VMath.rotationMatrix(this.yaw, this.pitch, this.roll, this.backingMatrix);
    }
}

