/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.vector;

import de.linusdev.lutils.math.vector.abstracts.floatn.FloatN;
import de.linusdev.lutils.math.vector.abstracts.intn.IntN;
import de.linusdev.lutils.math.vector.abstracts.longn.LongN;
import de.linusdev.lutils.nat.struct.abstracts.Structure;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public interface Vector {
    @NotNull
    public static <T extends Vector> String toString(@NotNull T vector, @NotNull String elementTypeName, @NotNull BiFunction<T, Integer, Object> getter) {
        StringBuilder sb = new StringBuilder().append(elementTypeName).append(vector.getMemberCount()).append(vector.isView() ? "view" : "").append("(").append(getter.apply(vector, 0));
        for (int i = 1; i < vector.getMemberCount(); ++i) {
            sb.append(", ").append(getter.apply(vector, i));
        }
        return sb.append(")").toString();
    }

    public static boolean equals(@NotNull FloatN vector, float @NotNull [] data, float epsilon) {
        if (vector.getMemberCount() != data.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            if (!(Math.abs(vector.get(i) - data[i]) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull FloatN vector, @NotNull FloatN other, float epsilon) {
        if (vector.getMemberCount() != other.getMemberCount()) {
            return false;
        }
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            if (!(Math.abs(vector.get(i) - other.get(i)) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull IntN vector, @NotNull IntN other) {
        if (vector.getMemberCount() != other.getMemberCount()) {
            return false;
        }
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            if (vector.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull LongN vector, @NotNull LongN other) {
        if (vector.getMemberCount() != other.getMemberCount()) {
            return false;
        }
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            if (vector.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNormalized(@NotNull FloatN vector, float epsilon) {
        float res = 0.0f;
        for (int i = 0; i < vector.getMemberCount(); ++i) {
            float comp = vector.get(i);
            res += comp * comp;
        }
        return Math.abs(res - 1.0f) < epsilon;
    }

    public int getMemberCount();

    default public boolean areComponentsUnsigned() {
        return false;
    }

    public boolean isArrayBacked();

    public boolean isBufferBacked();

    @NotNull
    default public Structure getStructure() {
        throw new UnsupportedOperationException("This vector is not buffer backed.");
    }

    @NotNull
    default public Object getArray() {
        throw new UnsupportedOperationException("This vector is not array backed.");
    }

    public boolean isView();

    @NotNull
    default public View<?> getAsView() {
        throw new UnsupportedOperationException("This vector is not a view on another vector.");
    }

    public static abstract class View<V extends Vector>
    implements Vector {
        @NotNull
        protected final V original;
        protected final int @NotNull [] mapping;

        static int @NotNull [] recalculateMappingToOriginal(@NotNull View<?> view, int @NotNull [] mapping) {
            int[] viewMapping = view.getMapping();
            int[] newMapping = new int[mapping.length];
            for (int i = 0; i < mapping.length; ++i) {
                newMapping[i] = viewMapping[mapping[i]];
            }
            return newMapping;
        }

        public static boolean isMappingSpecial(@NotNull Vector view) {
            int[] mapping = view.getAsView().getMapping();
            for (int i = 0; i < mapping.length; ++i) {
                if (i == mapping[i]) continue;
                return true;
            }
            return false;
        }

        public static boolean isMappingSpecial(int @NotNull [] defaultMapping, @NotNull Vector viewToCheck) {
            int[] mapping = viewToCheck.getAsView().getMapping();
            for (int i = 0; i < mapping.length; ++i) {
                if (defaultMapping[i] == mapping[i]) continue;
                return true;
            }
            return defaultMapping.length != mapping.length;
        }

        public static boolean doesMappingCollide(int @NotNull [] mappingA, int @NotNull [] mappingB) {
            for (int a : mappingA) {
                for (int b : mappingB) {
                    if (a != b) continue;
                    return true;
                }
            }
            return false;
        }

        protected View(@NotNull V original, int @NotNull [] mapping) {
            if (original.isView()) {
                mapping = View.recalculateMappingToOriginal(original.getAsView(), mapping);
                original = original.getAsView().getOriginal();
            }
            this.original = original;
            this.mapping = mapping;
        }

        @NotNull
        public V getOriginal() {
            return this.original;
        }

        public int @NotNull [] getMapping() {
            return this.mapping;
        }

        @Override
        public boolean areComponentsUnsigned() {
            return this.original.areComponentsUnsigned();
        }

        @Override
        public boolean isArrayBacked() {
            return false;
        }

        @Override
        public boolean isBufferBacked() {
            return false;
        }

        @Override
        public boolean isView() {
            return true;
        }

        public abstract boolean hasFactor();

        @NotNull
        public Object getFactor() {
            throw new UnsupportedOperationException("This view has no factor");
        }

        @NotNull
        public View<V> getAsView() {
            return this;
        }
    }
}

