/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.math.vector.abstracts.doublen;

import de.linusdev.lutils.math.elements.DoubleElement;
import de.linusdev.lutils.math.vector.Vector;
import org.jetbrains.annotations.NotNull;

public interface DoubleN
extends Vector,
DoubleElement {
    public double get(int var1);

    public void put(int var1, double var2);

    @NotNull
    default public View getAsView() {
        throw new UnsupportedOperationException("This vector is not a view on another vector.");
    }

    @NotNull
    default public DoubleN fillFromArray(double @NotNull [] data) {
        for (int x = 0; x < this.getMemberCount(); ++x) {
            this.put(x, data[x]);
        }
        return this;
    }

    public static abstract class View
    extends Vector.View<DoubleN>
    implements DoubleN {
        protected View(@NotNull DoubleN original, int @NotNull [] mapping) {
            super(original, mapping);
        }

        @Override
        public double get(int index) {
            return ((DoubleN)this.original).get(this.mapping[index]);
        }

        @Override
        public void put(int index, double value) {
            ((DoubleN)this.original).put(this.mapping[index], value);
        }

        @Override
        public boolean hasFactor() {
            return false;
        }

        public double @NotNull [] getFactor() {
            throw new UnsupportedOperationException("This view has no factor");
        }

        @Override
        @NotNull
        public View getAsView() {
            return this;
        }

        public String toString() {
            return Vector.toString(this, "double", DoubleN::get);
        }
    }

    public static abstract class FactorView
    extends View
    implements DoubleN {
        protected final double @NotNull [] factor;

        static double @NotNull [] recalculateFactorToOriginal(@NotNull View view, int @NotNull [] mapping, double @NotNull [] factor) {
            double[] viewFactor = view.getFactor();
            double[] newFactor = new double[factor.length];
            for (int i = 0; i < mapping.length; ++i) {
                newFactor[i] = viewFactor[mapping[i]] * factor[i];
            }
            return newFactor;
        }

        protected FactorView(@NotNull DoubleN original, int @NotNull [] mapping, double @NotNull [] factor) {
            super(original, mapping);
            this.factor = original.isView() && original.getAsView().hasFactor() ? FactorView.recalculateFactorToOriginal(original.getAsView(), mapping, factor) : factor;
        }

        @Override
        public double get(int index) {
            return ((DoubleN)this.original).get(this.mapping[index]) * this.factor[index];
        }

        @Override
        public void put(int index, double value) {
            ((DoubleN)this.original).put(this.mapping[index], value / this.factor[index]);
        }

        @Override
        public boolean hasFactor() {
            return true;
        }

        @Override
        public double @NotNull [] getFactor() {
            return this.factor;
        }
    }
}

