/*
 * Decompiled with CFR 0.152.
 */
package de.linusdev.lutils.nat.array;

import de.linusdev.lutils.nat.NativeType;
import de.linusdev.lutils.nat.array.NativePrimitiveTypeArray;
import de.linusdev.lutils.nat.struct.annos.StructValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class NativeInt16Array
extends NativePrimitiveTypeArray<Short> {
    public static NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator GENERATOR = new NativePrimitiveTypeArray.PrimitiveArrayStaticGenerator(NativeType.INT16);

    public static NativeInt16Array newUnallocated() {
        return new NativeInt16Array(null, false);
    }

    public static NativeInt16Array newAllocatable(@NotNull StructValue structValue) {
        return new NativeInt16Array(structValue, true);
    }

    public static NativeInt16Array newAllocated(@NotNull StructValue structValue) {
        NativeInt16Array ret = NativeInt16Array.newAllocatable(structValue);
        ret.allocate();
        return ret;
    }

    protected NativeInt16Array(@Nullable StructValue structValue, boolean generateInfo) {
        super(structValue, generateInfo, GENERATOR);
    }

    @Override
    public Short get(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.getInt16(index);
    }

    public short getInt16(@Range(from=0L, to=0x7FFFFFFFL) int index) {
        return this.byteBuf.getShort(this.positions.position(index));
    }

    @Override
    public void set(int index, Short item) {
        this.setInt16(index, item);
    }

    public void setInt16(int index, short item) {
        this.byteBuf.putShort(this.positions.position(index), item);
    }
}

